<?php
class Cidadao {
	public $cpf;
	public $cns;
	public $cpf2;
	public $cns2;
	public $totalEncontrado;
	public $ok;
	public $sql1;
	public $sql12;
	public $sql13;
	public $sql14;
	public $sql2;
	private $con;
	// ---------------------------------
	public $nome;
	public $dtNascimento;
	public $mae;
	public $pai;
	public $dtObito;
	public $dtAtCad;
	// .................................
	public $cnsResponsavel;
	public $cpfResponsavel;
	public $cor1;
	public $cor2;
	public $sexo1;
	public $celular;
	public $maC;
	public $ine;
	public $cnes;
	public $unidadeSaude;
	public $cnsProfissional;
	public $maD;
	public $docObito;
	// -------------------------------------
	//    tb_fat_cad_individual
	// -------------------------------------
	public $cnsResponsavelCi;
	public $cpfResponsavelCi;
	public $tel1;
	public $tel2;
	public $dtObitoCi;
	public $docObitoCi;
	public $maCi;
	public $equipe;
	public $nomeProfissional;
	public $ativo;
	public $fichaInativa;
	public $faleceu;
	public $unificado;
	public $stDefi;
	public $stDefiAud;
	public $stDefiCog;
	public $stDefiOut;
	public $stDefiVis;
	public $stDefiFis;
	public $stHipertensao;
	public $stDiabete;
	public $stCancer;
	public $stGestante;
	public $stAcamado;
	public $stBeneficio;
	public $motBaixa;
	public $motBaixaDs;
	public $codimequipe;
	public $cidadao;
	public $cidadao2;
	public $cidadaoc;
	public $cidadaoc2;
	public $simplificado;
	// -------------------------------------
	//   tb_cds_cad_individual
	// -------------------------------------
	public $sexo2;
	public $email;
	public $cboProfissional;
	public $cnesProfissional;
	public $docObitoCds;
	// -------------------------------------
	//   tratamento
	// -------------------------------------
	public $ma;

    public function __construct($con, $cns, $cpf, $cns2, $cpf2, $nome = '', $dtNascimento = '', $mae = '') {
		$this->totalEncontrado = 0;
		$this->ok = false;
        $this->cpf = $cpf;
        $this->cns = $cns;
        $this->cpf2 = $cpf2;
        $this->cns2 = $cns2;
		$this->con = $con;
		
		$this->nome = '';
		$this->dtNascimento = '';
		$this->mae = '';
		$this->pai = '';
		$this->dtObito = '';
		$this->dtAtCad = '';
		$this->cnsResponsavel = '';
		$this->cpfResponsavel = '';
		$this->cor1 = '';
		$this->cor2 = '';
		$this->sexo1 = '';
		$this->celular = '';
		$this->maC = '';
		$this->ine = '';
		$this->cnes = '';
		$this->unidadeSaude = '';
		$this->cnsProfissional = '';
		$this->maD = '';
		$this->cnsResponsavelCi = '';
		$this->cpfResponsavelCi = '';
		$this->tel1 = '';
		$this->tel2 = '';
		$this->dtObitoCi = '';
		$this->docObito = '';
		$this->docObitoCi = '';
		$this->docObitoCds = '';
		$this->maCi = '';
		$this->equipe = '';
		$this->nomeProfissional = '';
		$this->ativo = '';
		$this->fichaInativa = '';
		$this->faleceu = '';
		$this->unificado = '';
		$this->stDefi = '';
		$this->stDefiAud = '';
		$this->stDefiCog = '';
		$this->stDefiOut = '';
		$this->stDefiVis = '';
		$this->stDefiFis = '';
		$this->stHipertensao = '';
		$this->stDiabete = '';
		$this->stCancer = '';
		$this->stGestante = '';
		$this->stAcamado = '';
		$this->stBeneficio = '';
		$this->motBaixa = '';
		$this->motBaixaDs = '';
		$this->codimequipe = '';
		$this->sexo2 = '';
		$this->email = '';
		$this->cboProfissional = '';
		$this->cnesProfissional = '';
		$this->ma = '';
		$this->cidadao = '';
		$this->cidadao2 = '';
		$this->cidadaoc = '';
		$this->cidadaoc2 = '';
		$this->simplificado = true;
		
		$n_busca = "";
		if (strlen($nome) > 0){
			$n_busca = "no_cidadao LIKE '%".$nome."%'";
		}
		$d_busca = "";
		$d_busca2 = "";
		if (strlen($dtNascimento) > 0){
			$d_busca = "dt_nascimento = '".$dtNascimento."'";
			$d_busca2 = "date(dt_nascimento) = '".$dtNascimento."'";
		}
		$m_busca_1 = "";
		$m_busca_2 = "";
		if (strlen($mae) > 0){
			$m_busca_1 = "no_mae LIKE '%".$mae."%'";
			$m_busca_2 = "no_mae_cidadao LIKE '%".$mae."%'";
		}
		$x_busca_1 = "";
		$x_busca_2 = "";
		if (strlen($n_busca) > 0 || strlen($d_busca) > 0 || strlen($m_busca_1) > 0){
			$x_busca_1 .= "OR (";
			$x_busca_2 .= "OR (";
			if (strlen($n_busca) > 0){
				$x_busca_1 .= $n_busca;
				$x_busca_2 .= $n_busca;
				if (strlen($d_busca) > 0){
					$x_busca_1 .= " AND ".$d_busca;
					$x_busca_2 .= " AND ".$d_busca2;
					if (strlen($m_busca_1) > 0){
						$x_busca_1 .= " AND ".$m_busca_1;
						$x_busca_2 .= " AND ".$m_busca_2;
					}
				} else {
					if (strlen($m_busca_1) > 0){
						$x_busca_1 .= " AND ".$m_busca_1;
						$x_busca_2 .= " AND ".$m_busca_2;
					}
				}
			} else {
				if (strlen($d_busca) > 0){
					$x_busca_1 .= $d_busca;
					$x_busca_2 .= $d_busca2;
					if (strlen($m_busca_1) > 0){
						$x_busca_1 .= " AND ".$m_busca_1;
						$x_busca_2 .= " AND ".$m_busca_2;
					}
				} else {
					if (strlen($m_busca_1) > 0){
						$x_busca_1 .= $m_busca_1;
						$x_busca_2 .= $m_busca_2;
					}
				}
			}
			$x_busca_1 .= ")";
			$x_busca_2 .= ")";
		}

		// ####################################################################################################################################################
		$sql_v1 = "
			SELECT
				nu_cns,
				nu_cpf,
				no_cidadao,
				dt_nascimento,
				no_mae,
				no_pai,
				dt_obito,
				no_sexo,
				TO_CHAR(dt_atualizado, 'YYYYMMDD') as co_dim_tempo_c,
				nu_documento_obito
			FROM
				tb_cidadao
			WHERE
				nu_cns = ? OR nu_cpf = ? OR nu_cns = ? OR nu_cpf = ? ".$x_busca_1."
			ORDER BY co_seq_cidadao DESC
			-- LIMIT 1
		";
		// ####################################################################################################################################################
		$sql_v2 = "
			SELECT
				nu_cns_cidadao,
				nu_cpf_cidadao,
				no_cidadao,
				dt_nascimento,
				no_mae_cidadao,
				no_pai_cidadao,
				date(dt_obito) as dt_obito,
				nu_declaracao_obito,
				TO_CHAR(dt_cad_individual, 'YYYYMMDD') as co_dim_tempo_c
			FROM 
				tb_cds_cad_individual 
			WHERE 
				nu_cns_cidadao = ? OR nu_cpf_cidadao = ? OR nu_cns_cidadao = ? OR nu_cpf_cidadao = ? ".$x_busca_2."
			ORDER BY co_seq_cds_cad_individual DESC 
			-- LIMIT 1
		";
		// ####################################################################################################################################################
		
		$rs1 = $this->con->prepare($sql_v1);
		$rs1->bindParam(1,$cns);
		$rs1->bindParam(2,$cpf);
		$rs1->bindParam(3,$cns2);
		$rs1->bindParam(4,$cpf2);
		if($rs1->execute()){
			if($rs1->rowCount() > 0){
				$this->totalEncontrado = $rs1->rowCount();
				while($row1 = $rs1->fetch(PDO::FETCH_OBJ)){
					$this->ok = true;
					
					if (strlen($this->cns) <= 0){
						$this->cns = $row1->nu_cns;
					} else {
						if (($this->cns != $row1->nu_cns) && (strlen($row1->nu_cns) == 15)){
							$this->cns2 = $row1->nu_cns;
						}
					}
					if (strlen($this->cpf) <= 0){
						$this->cpf = $row1->nu_cpf;
					} else {
						if (($this->cpf != $row1->nu_cpf) && (strlen($row1->nu_cpf) == 11)){
							$this->cpf2 = $row1->nu_cpf;
						}
					}

					$this->nome = (strlen($this->nome) <= 0) ? $row1->no_cidadao : $this->nome;
					$this->dtNascimento = (strlen($this->dtNascimento) <= 0) ? $row1->dt_nascimento : $this->dtNascimento;
					$this->mae = (strlen($this->mae) <= 0) ? $row1->no_mae : $this->mae;
					$this->pai = (strlen($this->pai) <= 0) ? $row1->no_pai : $this->pai;
					$this->dtObito = (strlen($this->dtObito) <= 0) ? $row1->dt_obito : $this->dtObito;
					$this->dtAtCad = (strlen($this->dtAtCad) <= 0) ? $row1->co_dim_tempo_c : $this->dtAtCad;
					$this->docObito = (strlen($this->docObito) <= 0) ? $row1->nu_documento_obito : $this->docObito;
				}
			} else {
				$rs2 = $this->con->prepare($sql_v2);
				$rs2->bindParam(1,$cns);
				$rs2->bindParam(2,$cpf);
				$rs2->bindParam(3,$cns2);
				$rs2->bindParam(4,$cpf2);
				if($rs2->execute()){
					if($rs2->rowCount() > 0){
						$this->totalEncontrado = $rs2->rowCount();
						while($row2 = $rs2->fetch(PDO::FETCH_OBJ)){
							$this->ok = true;
							
							if (strlen($this->cns) <= 0){
								$this->cns = $row2->nu_cns_cidadao;
							} else {
								if (($this->cns != $row2->nu_cns_cidadao) && (strlen($row2->nu_cns_cidadao) == 15)){
									$this->cns2 = $row2->nu_cns_cidadao;
								}
							}
							if (strlen($this->cpf) <= 0){
								$this->cpf = $row2->nu_cpf_cidadao;
							} else {
								if (($this->cpf != $row2->nu_cpf_cidadao) && (strlen($row2->nu_cpf_cidadao) == 11)){
									$this->cpf2 = $row2->nu_cpf_cidadao;
								}
							}

							$this->nome = (strlen($this->nome) <= 0) ? $row2->no_cidadao : $this->nome;
							$this->dtNascimento = (strlen($this->dtNascimento) <= 0) ? $row2->dt_nascimento : $this->dtNascimento;
							$this->mae = (strlen($this->mae) <= 0) ? $row2->no_mae_cidadao : $this->mae;
							$this->pai = (strlen($this->pai) <= 0) ? $row2->no_pai_cidadao : $this->pai;
							$this->dtObito = (strlen($this->dtObito) <= 0) ? $row2->dt_obito : $this->dtObito;
							$this->dtAtCad = (strlen($this->dtAtCad) <= 0) ? $row2->co_dim_tempo_c : $this->dtAtCad;
							$this->docObitoCds = (strlen($this->docObitoCds) <= 0) ? $row2->nu_declaracao_obito : $this->docObitoCds;
						}
					}
				}
			}
		}
		
		// ####################################################################################################################################################
		$this->sql1 = "
		-- pega dados e endereco via FAT
		--fat_cns
		--fat_cpf
		--fat_nome
		--fat_dt_nascimento
		--fat_mae
		--fat_pai
		--fat_cns_responsavel
		--fat_cpf_responsavel
		--fat_cns_responsavel_ci
		--fat_cpf_responsavel_ci
		--fat_cor1
		--fat_cor2
		--fat_sexo1
		--fat_celular
		--fat_tel1
		--fat_tel2
		--fat_dt_obito
		--fat_dt_obito_ci
		--fat_ma_c
		--fat_ma_ci
		--fat_ine
		--fat_equipe
		--fat_cnes
		--fat_unidade_saude
		--fat_cns_profissional
		--fat_nome_profissional
		--fat_ativo
		--fat_ficha_inativa
		--fat_faleceu
		--fat_unificado
		--fat_st_defi
		--fat_st_defi_aud
		--fat_st_defi_cog
		--fat_st_defi_out
		--fat_st_defi_vis
		--fat_st_defi_fis
		--fat_st_hipertensao
		--fat_st_diabete
		--fat_st_cancer
		--fat_st_gestante
		--fat_st_acamado
		--fat_st_beneficio
		--fat_mot_baixa
		--fat_mot_baixa_ds
		SELECT
			t8.co_seq_cidadao AS fat_cidadaoc,
			t8.nu_cns AS fat_cns,
			t8.nu_cpf AS fat_cpf,
			t8.no_cidadao AS fat_nome,
			t8.dt_nascimento AS fat_dt_nascimento,
			t8.no_mae AS fat_mae,
			t8.no_pai AS fat_pai,
			t8.nu_cns_responsavel AS fat_cns_responsavel,
			t8.nu_cpf_responsavel AS fat_cpf_responsavel,
			t8.nu_cns_responsavel_ci AS fat_cns_responsavel_ci,
			t8.nu_cpf_responsavel_ci AS fat_cpf_responsavel_ci,
			t8.fat_cor1,
			t8.fat_cor2,
			t8.no_sexo AS fat_sexo1,
			t8.nu_telefone_celular AS fat_celular,
			t8.nu_telefone_residencial AS fat_tel1,
			t8.nu_telefone_contato AS fat_tel2,
			t8.dt_obito AS fat_dt_obito,
			t8.dt_obito_ci AS fat_dt_obito_ci,
			t8.co_dim_tempo AS fat_dt_at_cad,
			t8.co_dim_tempo_c AS fat_dt_at_cad_c,
			t8.nu_micro_area AS fat_ma_c,
			t8.nu_micro_area_ci AS fat_ma_ci,
			t8.nu_ine AS fat_ine,
			t8.no_equipe AS fat_equipe,
			t8.nu_cnes AS fat_cnes,
			t8.no_unidade_saude AS fat_unidade_saude,
			t8.nu_cns_prof AS fat_cns_profissional,
			t8.no_profissional AS fat_nome_profissional,
			t8.st_ativo AS fat_ativo,
			t8.st_ficha_inativa AS fat_ficha_inativa,
			t8.st_faleceu AS fat_faleceu,
			t8.st_unificado AS fat_unificado,
			t8.st_deficiencia AS fat_st_defi,
			t8.st_defi_auditiva AS fat_st_defi_aud,
			t8.st_defi_intelectual_cognitiva AS fat_st_defi_cog,
			t8.st_defi_outra AS fat_st_defi_out,
			t8.st_defi_visual AS fat_st_defi_vis,
			t8.st_defi_fisica AS fat_st_defi_fis,
			t8.st_hipertensao_arterial AS fat_st_hipertensao,
			t8.st_diabete AS fat_st_diabete,
			t8.st_cancer AS fat_st_cancer,
			t8.st_gestante AS fat_st_gestante,
			t8.st_acamado AS fat_st_acamado,
			t8.st_recebe_beneficio AS fat_st_beneficio,
			t8.co_dim_tipo_saida_cadastro AS fat_mot_baixa,
			t8.fat_mot_baixa_ds,
			t8.co_dim_equipe,
			t8.doc_obito,
			t8.doc_obito_ci
		FROM
		(
			SELECT
				t71.*,
				tb_dim_tipo_saida_cadastro.ds_dim_tipo_saida_cadastro AS fat_mot_baixa_ds
			FROM
			(
					SELECT
						t6.*,
						tb_raca_cor.no_identificador AS fat_cor1,
						tb_raca_cor.co_raca_cor_cadsus AS fat_cor2
					FROM
					(
							-- (05) -------------------------------------------------------------------------------------------
							SELECT
								t4.*,
								tb_dim_profissional.nu_cns AS nu_cns_prof,
								tb_dim_profissional.no_profissional
							FROM
							(
								-- (04) -------------------------------------------------------------------------------------------
								SELECT
									t3.*,
									tb_dim_unidade_saude.nu_cnes,
									tb_dim_unidade_saude.no_unidade_saude
								FROM
								(
									-- (03) -------------------------------------------------------------------------------------------
									SELECT
										t2.*,
										tb_dim_equipe.nu_ine,
										tb_dim_equipe.no_equipe
									FROM
									(
										-- (02) -------------------------------------------------------------------------------------------
										SELECT
											t1.co_seq_cidadao,
											t1.no_cidadao,
											t1.nu_cpf,
											t1.nu_cns,
											t1.dt_nascimento,
											t1.no_mae,
											t1.no_sexo,
											t1.nu_micro_area,
											t1.nu_cns_responsavel,
											t1.nu_cpf_responsavel,
											t1.st_ativo,
											t1.dt_obito,
											t1.st_faleceu,
											t1.no_pai,
											t1.ds_logradouro,
											t1.ds_complemento,
											t1.co_uf,
											t1.nu_numero,
											t1.no_bairro,
											t1.st_unificado,
											t1.nu_telefone_residencial,
											t1.nu_telefone_celular,
											t1.nu_telefone_contato,
											t1.tp_logradouro,
											t1.ds_cep,
											t1.co_raca_cor,
											t1.co_localidade_endereco,
											t1.nu_documento_obito AS doc_obito,
											TO_CHAR(t1.dt_atualizado, 'YYYYMMDD') as co_dim_tempo_c,
											tb_fat_cad_individual.co_dim_unidade_saude,
											tb_fat_cad_individual.co_dim_equipe,
											tb_fat_cad_individual.co_dim_tempo,
											tb_fat_cad_individual.co_seq_fat_cad_individual,
											tb_fat_cad_individual.nu_cns_responsavel AS nu_cns_responsavel_ci,
											tb_fat_cad_individual.nu_cpf_responsavel AS nu_cpf_responsavel_ci,
											tb_fat_cad_individual.st_deficiencia,
											tb_fat_cad_individual.st_defi_auditiva,
											tb_fat_cad_individual.st_defi_intelectual_cognitiva,
											tb_fat_cad_individual.st_defi_outra,
											tb_fat_cad_individual.st_defi_visual,
											tb_fat_cad_individual.st_defi_fisica,
											tb_fat_cad_individual.st_hipertensao_arterial,
											tb_fat_cad_individual.st_diabete,
											tb_fat_cad_individual.st_cancer,
											tb_fat_cad_individual.st_gestante,
											tb_fat_cad_individual.st_acamado,
											tb_fat_cad_individual.st_recebe_beneficio,
											tb_fat_cad_individual.dt_obito AS dt_obito_ci,
											tb_fat_cad_individual.nu_micro_area AS nu_micro_area_ci,
											tb_fat_cad_individual.st_ficha_inativa,
											tb_fat_cad_individual.co_dim_profissional,
											tb_fat_cad_individual.co_dim_tipo_saida_cadastro,
											tb_fat_cad_individual.nu_obito_do AS doc_obito_ci
										FROM
										(
											-- (01) -------------------------------------------------------------------------------------------
											SELECT
												*
											FROM
												tb_cidadao
											WHERE
												nu_cns = ? OR nu_cpf = ? OR nu_cns = ? OR nu_cpf = ? ".$x_busca_1."
											-- (01) -------------------------------------------------------------------------------------------
										) AS t1
										LEFT JOIN
											tb_fat_cad_individual
										ON t1.nu_cns = tb_fat_cad_individual.nu_cns OR t1.nu_cpf = tb_fat_cad_individual.nu_cpf_cidadao
										-- (02) -------------------------------------------------------------------------------------------
									) AS t2
									LEFT JOIN
										tb_dim_equipe
									ON t2.co_dim_equipe = tb_dim_equipe.co_seq_dim_equipe
									-- (03) -------------------------------------------------------------------------------------------
								) AS t3
								LEFT JOIN
									tb_dim_unidade_saude
								ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t3.co_dim_unidade_saude
								-- (04) -------------------------------------------------------------------------------------------
							) AS t4
							LEFT JOIN
								tb_dim_profissional
							ON tb_dim_profissional.co_seq_dim_profissional = t4.co_dim_profissional
							-- (05) -------------------------------------------------------------------------------------------
					) AS t6
					LEFT JOIN
						tb_raca_cor
					ON tb_raca_cor.co_raca_cor = t6.co_raca_cor
			) AS t71
			LEFT JOIN
				tb_dim_tipo_saida_cadastro
			ON tb_dim_tipo_saida_cadastro.co_seq_dim_tipo_saida_cadastro = t71.co_dim_tipo_saida_cadastro
		) AS t8
		ORDER BY co_seq_fat_cad_individual DESC
		";
		// ####################################################################################################################################################
		$this->sql13 = "
			SELECT
				co_seq_fat_cidadao_pec,
				st_faleceu
			FROM 
				tb_fat_cidadao_pec
			WHERE
				nu_cns = ? OR nu_cpf_cidadao = ?
			LIMIT 1
		";
		// ####################################################################################################################################################
		$this->sql14 = "
			SELECT
				t2.*,
				tb_equipe.no_equipe
			FROM
			(
				SELECT 
					t1.*,
					tb_unidade_saude.no_unidade_saude
				FROM
				(
					SELECT 
						nu_cnes, 
						nu_ine
					FROM 
						tb_cidadao_vinculacao_equipe
					WHERE 
						co_cidadao = ?
					ORDER BY co_seq_cidadao_vinculacao_eqp DESC
					LIMIT 1
				) AS t1
				LEFT JOIN
					tb_unidade_saude
				ON tb_unidade_saude.nu_cnes = t1.nu_cnes
			) AS t2
			LEFT JOIN
				tb_equipe
			ON tb_equipe.nu_ine = t2.nu_ine
		";
		// ####################################################################################################################################################
		$this->sql2 = "
		-- pega dados e endereco via CDS
		--cds_cns
		--cds_cpf
		--cds_nome
		--cds_dt_nascimento
		--cds_mae
		--cds_pai
		--cds_cns_responsavel
		--cds_cpf_responsavel
		--cds_cor1
		--cds_cor2
		--cds_sexo1
		--cds_sexo2
		--cds_celular
		--cds_email
		--cds_dt_obito
		--cds_ma_c
		--cds_ine
		--cds_cnes
		--cds_unidade_saude
		--cds_cbo_profissional
		--cds_cns_profissional
		--cds_cnes_profissional
		--cds_ma_d
		SELECT
			t4.nu_cartao_sus_responsavel AS cds_cns_responsavel,
			t4.nu_cns_cidadao AS cds_cns,
			t4.no_cidadao AS cds_nome,
			t4.dt_nascimento AS cds_dt_nascimento,
			t4.no_mae_cidadao AS cds_mae,
			t4.nu_celular_cidadao AS cds_celular,
			t4.ds_email_cidadao AS cds_email,
			t4.no_pai_cidadao AS cds_pai,
			t4.dt_obito AS cds_dt_obito,
			t4.nu_declaracao_obito AS cds_doc_obito,
			t4.nu_micro_area AS cds_ma_c,
			t4.nu_cpf_cidadao AS cds_cpf,
			t4.nu_cpf_responsavel AS cds_cpf_responsavel,
			t4.nu_cnes AS cds_cnes,
			t4.no_unidade_saude AS cds_unidade_saude,
			t4.cds_cor1,
			t4.cds_cor2,
			t4.cds_sexo1,
			t4.cds_sexo2,
			t4.co_dim_tempo_c AS cds_dt_at_cad,
			tb_cds_prof.nu_cns AS cds_cns_profissional,
			tb_cds_prof.nu_ine AS cds_ine,
			tb_cds_prof.nu_cbo_2002 AS cds_cbo_profissional,
			tb_cds_prof.nu_cnes AS cds_cnes_profissional
		FROM
		(
			SELECT
				t3.*,
				tb_raca_cor.no_identificador AS cds_cor1,
				tb_raca_cor.co_raca_cor_cadsus AS cds_cor2
			FROM
			(
				SELECT
					t2.*,
					tb_sexo.no_identificador AS cds_sexo1,
					tb_sexo.sg_sexo AS cds_sexo2
				FROM
				(
					SELECT
						t1.*,
						tb_unidade_saude.nu_cnes,
						tb_unidade_saude.no_unidade_saude
					FROM
					(
						SELECT
							nu_cartao_sus_responsavel,
							co_unidade_saude,
							nu_cns_cidadao,
							no_cidadao,
							dt_nascimento,
							co_raca_cor,
							co_sexo,
							no_mae_cidadao,
							nu_celular_cidadao,
							ds_email_cidadao,
							co_cds_prof_cadastrante,
							no_pai_cidadao,
							date(dt_obito) as dt_obito,
							nu_micro_area,
							nu_cpf_cidadao,
							nu_cpf_responsavel,
							TO_CHAR(dt_cad_individual, 'YYYYMMDD') as co_dim_tempo_c,
							nu_declaracao_obito
						FROM 
							tb_cds_cad_individual 
						WHERE 
							nu_cns_cidadao = ? OR nu_cpf_cidadao = ? OR nu_cns_cidadao = ? OR nu_cpf_cidadao = ? ".$x_busca_2."
						ORDER BY co_seq_cds_cad_individual DESC 
						-- LIMIT 1
					) AS t1
					LEFT JOIN
						tb_unidade_saude
					ON tb_unidade_saude.co_seq_unidade_saude = t1.co_unidade_saude
				) AS t2
				LEFT JOIN
					tb_sexo
				ON tb_sexo.co_sexo = t2.co_sexo
			) AS t3
			LEFT JOIN
				tb_raca_cor
			ON tb_raca_cor.co_raca_cor = t3.co_raca_cor
		) AS t4
		LEFT JOIN
			tb_cds_prof
		ON tb_cds_prof.co_seq_cds_prof = t4.co_cds_prof_cadastrante
		";
		// ####################################################################################################################################################
	}
	public function dados(){
		if ($this->ok){
			$rs1 = $this->con->prepare($this->sql1);
			$rs1->bindParam(1,$this->cns);
			$rs1->bindParam(2,$this->cpf);
			$rs1->bindParam(3,$this->cns2);
			$rs1->bindParam(4,$this->cpf2);
			if($rs1->execute()){
				if($rs1->rowCount() > 0){
					$this->totalEncontrado = $rs1->rowCount();
					while($row1 = $rs1->fetch(PDO::FETCH_OBJ)){
						// -------------------------------------
						$this->ok = true;
						
						if (strlen($this->cns) <= 0){
							$this->cns = $row1->fat_cns;
						} else {
							if (($this->cns != $row1->fat_cns) && (strlen($row1->fat_cns) == 15)){
								$this->cns2 = $row1->fat_cns;
							}
						}
						if (strlen($this->cpf) <= 0){
							$this->cpf = $row1->fat_cpf;
						} else {
							if (($this->cpf != $row1->fat_cpf) && (strlen($row1->fat_cpf) == 11)){
								$this->cpf2 = $row1->fat_cpf;
							}
						}
						$this->cidadaoc = (strlen($this->cidadaoc) <= 0) ? $row1->fat_cidadaoc : $this->cidadaoc;
						$this->nome = (strlen($this->nome) <= 0) ? $row1->fat_nome : $this->nome;
						$this->dtNascimento = (strlen($this->dtNascimento) <= 0) ? $row1->fat_dt_nascimento : $this->dtNascimento;
						$this->mae = (strlen($this->mae) <= 0) ? $row1->fat_mae : $this->mae;
						$this->pai = (strlen($this->pai) <= 0) ? $row1->fat_pai : $this->pai;
						$this->cnsResponsavel = (strlen($this->cnsResponsavel) <= 0) ? $row1->fat_cns_responsavel : $this->cnsResponsavel;
						$this->cpfResponsavel = (strlen($this->cpfResponsavel) <= 0) ? $row1->fat_cpf_responsavel : $this->cpfResponsavel;
						$this->cor1 = (strlen($this->cor1) <= 0) ? $row1->fat_cor1 : $this->cor1;
						$this->cor2 = (strlen($this->cor2) <= 0) ? $row1->fat_cor2 : $this->cor2;
						$this->sexo1 = (strlen($this->sexo1) <= 0) ? $row1->fat_sexo1 : $this->sexo1;
						$this->celular = (strlen($this->celular) <= 0) ? $row1->fat_celular : $this->celular;
						$this->dtObito = (strlen($this->dtObito) <= 0) ? $row1->fat_dt_obito : $this->dtObito;
						$this->docObito = (strlen($this->docObito) <= 0) ? $row1->doc_obito : $this->docObito;
						$this->dtAtCad = (strlen($this->dtAtCad) <= 0) ? $row1->fat_dt_at_cad : $this->dtAtCad;
						$this->maC = (strlen($this->maC) <= 0) ? $row1->fat_ma_c : $this->maC;
						$this->ine = (strlen($this->ine) <= 0) ? $row1->fat_ine : $this->ine;
						$this->cnes = (strlen($this->cnes) <= 0) ? $row1->fat_cnes : $this->cnes;
						$this->unidadeSaude = (strlen($this->unidadeSaude) <= 0) ? $row1->fat_unidade_saude : $this->unidadeSaude;
						$this->cnsProfissional = (strlen($this->cnsProfissional) <= 0) ? $row1->fat_cns_profissional : $this->cnsProfissional;
						// -------------------------------------
						$this->cnsResponsavelCi = (strlen($this->cnsResponsavelCi) <= 0) ? $row1->fat_cns_responsavel_ci : $this->cnsResponsavelCi;
						$this->cpfResponsavelCi = (strlen($this->cpfResponsavelCi) <= 0) ? $row1->fat_cpf_responsavel_ci : $this->cpfResponsavelCi;
						$this->tel1 = (strlen($this->tel1) <= 0) ? $row1->fat_tel1 : $this->tel1;
						$this->tel2 = (strlen($this->tel2) <= 0) ? $row1->fat_tel2 : $this->tel2;
						$this->dtObitoCi = (strlen($this->dtObitoCi) <= 0) ? $row1->fat_dt_obito_ci : $this->dtObitoCi;
						$this->docObitoCi = (strlen($this->docObitoCi) <= 0) ? $row1->doc_obito_ci : $this->docObitoCi;
						$this->maCi = (strlen($this->maCi) <= 0) ? $row1->fat_ma_ci : $this->maCi;
						$this->equipe = (strlen($this->equipe) <= 0) ? $row1->fat_equipe : $this->equipe;
						$this->nomeProfissional = (strlen($this->nomeProfissional) <= 0) ? $row1->fat_nome_profissional : $this->nomeProfissional;
						$this->ativo = (strlen($this->ativo) <= 0) ? $row1->fat_ativo : $this->ativo;
						$this->fichaInativa = (strlen($this->fichaInativa) <= 0) ? $row1->fat_ficha_inativa : $this->fichaInativa;
						$this->faleceu = (strlen($this->faleceu) <= 0) ? $row1->fat_faleceu : $this->faleceu;
						$this->unificado = (strlen($this->unificado) <= 0) ? $row1->fat_unificado : $this->unificado;
						$this->stDefi = (strlen($this->stDefi) <= 0) ? $row1->fat_st_defi : $this->stDefi;
						$this->stDefiAud = (strlen($this->stDefiAud) <= 0) ? $row1->fat_st_defi_aud : $this->stDefiAud;
						$this->stDefiCog = (strlen($this->stDefiCog) <= 0) ? $row1->fat_st_defi_cog : $this->stDefiCog;
						$this->stDefiOut = (strlen($this->stDefiOut) <= 0) ? $row1->fat_st_defi_out : $this->stDefiOut;
						$this->stDefiVis = (strlen($this->stDefiVis) <= 0) ? $row1->fat_st_defi_vis : $this->stDefiVis;
						$this->stDefiFis = (strlen($this->stDefiFis) <= 0) ? $row1->fat_st_defi_fis : $this->stDefiFis;
						$this->stHipertensao = (strlen($this->stHipertensao) <= 0) ? $row1->fat_st_hipertensao : $this->stHipertensao;
						$this->stDiabete = (strlen($this->stDiabete) <= 0) ? $row1->fat_st_diabete : $this->stDiabete;
						$this->stCancer = (strlen($this->stCancer) <= 0) ? $row1->fat_st_cancer : $this->stCancer;
						$this->stGestante = (strlen($this->stGestante) <= 0) ? $row1->fat_st_gestante : $this->stGestante;
						$this->stAcamado = (strlen($this->stAcamado) <= 0) ? $row1->fat_st_acamado : $this->stAcamado;
						$this->stBeneficio = (strlen($this->stBeneficio) <= 0) ? $row1->fat_st_beneficio : $this->stBeneficio;
						$this->motBaixa = (strlen($this->motBaixa) <= 0) ? $row1->fat_mot_baixa : $this->motBaixa;
						$this->motBaixaDs = (strlen($this->motBaixaDs) <= 0) ? $row1->fat_mot_baixa_ds : $this->motBaixaDs;
						$this->codimequipe = (strlen($this->codimequipe) <= 0) ? $row1->co_dim_equipe : $this->codimequipe;
						$rs3 = $this->con->prepare($this->sql13);
						$rs3->bindParam(1,$row1->fat_cns);
						$rs3->bindParam(2,$row1->fat_cpf);
						if($rs3->execute()){
							if($rs3->rowCount() > 0){
								while($row3 = $rs3->fetch(PDO::FETCH_OBJ)){
									$this->cidadao = $row3->co_seq_fat_cidadao_pec;
									$this->faleceu = (strlen($this->faleceu) <= 0) ? $row3->st_faleceu : $this->faleceu;
								}
							}
						}
						if (strlen($this->cidadaoc) > 0){
							$rs33 = $this->con->prepare($this->sql14);
							$rs33->bindParam(1,$row1->fat_cidadaoc);
							if($rs33->execute()){
								if($rs33->rowCount() > 0){
									while($row33 = $rs33->fetch(PDO::FETCH_OBJ)){
										$this->cnes = (strlen($this->cnes) <= 0) ? $row33->nu_cnes : $this->cnes;
										$this->ine = (strlen($this->ine) <= 0) ? $row33->nu_ine : $this->ine;
										$this->equipe = (strlen($this->equipe) <= 0) ? $row33->no_equipe : $this->equipe;
										$this->unidadeSaude = (strlen($this->unidadeSaude) <= 0) ? $row33->no_unidade_saude : $this->unidadeSaude;
									}
								}
							}
						}
						if (strlen($this->cidadao) > 0){
							$this->simplificado = false;
						}
					}
				} else {
					$rs2 = $this->con->prepare($this->sql2);
					$rs2->bindParam(1,$this->cns);
					$rs2->bindParam(2,$this->cpf);
					$rs2->bindParam(3,$this->cns2);
					$rs2->bindParam(4,$this->cpf2);
					if($rs2->execute()){
						if($rs2->rowCount() > 0){
							$this->totalEncontrado = $rs2->rowCount();
							while($row2 = $rs2->fetch(PDO::FETCH_OBJ)){
								// -------------------------------------
								$this->ok = true;

								if (strlen($this->cns) <= 0){
									$this->cns = $row2->cds_cns;
								} else {
									if (($this->cns != $row2->cds_cns) && (strlen($row2->cds_cns) == 15)){
										$this->cns2 = $row2->cds_cns;
									}
								}
								if (strlen($this->cpf) <= 0){
									$this->cpf = $row2->cds_cpf;
								} else {
									if (($this->cpf != $row2->cds_cpf) && (strlen($row2->cds_cpf) == 11)){
										$this->cpf2 = $row2->cds_cpf;
									}
								}

								$this->nome = (strlen($this->nome) <= 0) ? $row2->cds_nome : $this->nome;
								$this->dtNascimento = (strlen($this->dtNascimento) <= 0) ? $row2->cds_dt_nascimento : $this->dtNascimento;
								$this->mae = (strlen($this->mae) <= 0) ? $row2->cds_mae : $this->mae;
								$this->pai = (strlen($this->pai) <= 0) ? $row2->cds_pai : $this->pai;
								$this->cnsResponsavel = (strlen($this->cnsResponsavel) <= 0) ? $row2->cds_cns_responsavel : $this->cnsResponsavel;
								$this->cpfResponsavel = (strlen($this->cpfResponsavel) <= 0) ? $row2->cds_cpf_responsavel : $this->cpfResponsavel;
								$this->cor1 = (strlen($this->cor1) <= 0) ? $row2->cds_cor1 : $this->cor1;
								$this->cor2 = (strlen($this->cor2) <= 0) ? $row2->cds_cor2 : $this->cor2;
								$this->sexo1 = (strlen($this->sexo1) <= 0) ? $row2->cds_sexo1 : $this->sexo1;
								$this->celular = (strlen($this->celular) <= 0) ? $row2->cds_celular : $this->celular;
								$this->dtObito = (strlen($this->dtObito) <= 0) ? $row2->cds_dt_obito : $this->dtObito;
								$this->docObito = (strlen($this->docObito) <= 0) ? $row2->cds_doc_obito : $this->docObito;
								$this->dtAtCad = (strlen($this->dtAtCad) <= 0) ? $row2->cds_dt_at_cad : $this->dtAtCad;
								$this->maC = (strlen($this->maC) <= 0) ? $row2->cds_ma_c : $this->maC;
								$this->ine = (strlen($this->ine) <= 0) ? $row2->cds_ine : $this->ine;
								$this->cnes = (strlen($this->cnes) <= 0) ? $row2->cds_cnes : $this->cnes;
								$this->unidadeSaude = (strlen($this->unidadeSaude) <= 0) ? $row2->cds_unidade_saude : $this->unidadeSaude;
								$this->cnsProfissional = (strlen($this->cnsProfissional) <= 0) ? $row2->cds_cns_profissional : $this->cnsProfissional;
								$this->maD = '';
								// -------------------------------------
								$this->sexo2 = (strlen($this->sexo2) <= 0) ? $row2->cds_sexo2 : $this->sexo2;
								$this->email = (strlen($this->email) <= 0) ? $row2->cds_email : $this->email;
								$this->cboProfissional = (strlen($this->cboProfissional) <= 0) ? $row2->cds_cbo_profissional : $this->cboProfissional;
								$this->cnesProfissional = (strlen($this->cnesProfissional) <= 0) ? $row2->cds_cnes_profissional : $this->cnesProfissional;
								// -------------------------------------
							}
						}
					}
				}
			}
			if ($this->ok){
				if (strlen($this->maC) > 0){
					$this->ma = $this->maC;
				}
				if (strlen($this->maCi) > 0){
					if ($this->ma != $this->maCi){
						if (strlen($this->ma) > 0){
							$this->ma .= "|".$this->maCi;
						} else {
							$this->ma = $this->maCi;
						}
					}
				}
				if (strlen($this->maD) > 0){
					if ($this->ma != $this->maD){
						if (strlen($this->ma) > 0){
							$this->ma .= "|".$this->maD;
						} else {
							$this->ma = $this->maD;
						}
					}
				}
				if (strlen($this->dtObitoCi) > 0){
					if ($this->dtObito != $this->dtObitoCi){
						if (strlen($this->dtObito) > 0){
							$this->dtObito .= "|".$this->dtObitoCi;
						} else {
							$this->dtObito = $this->dtObitoCi;
						}
					}
				}
				if (strlen($this->docObitoCi) > 0){
					if ($this->docObito != $this->docObitoCi){
						if (strlen($this->docObito) > 0){
							$this->docObito .= "|".$this->docObitoCi;
						} else {
							$this->docObito = $this->docObitoCi;
						}
					}
				}
				if (strlen($this->docObito) <= 0 || strlen($this->dtObito) <= 0){
					$rscdsob = $this->con->prepare("select date(dt_obito) as dt_obito, nu_declaracao_obito from tb_cds_cad_individual where no_cidadao = ? and date(dt_nascimento) = ? and dt_obito notnull order by co_seq_cds_cad_individual desc limit 1");
					$rscdsob->bindParam(1,$this->nome);
					$rscdsob->bindParam(2,$this->dtNascimento);
					if($rscdsob->execute()){
						if($rscdsob->rowCount() > 0){
							while($rowcdsob = $rscdsob->fetch(PDO::FETCH_OBJ)){
								$this->dtObito = (strlen($this->dtObito) <= 0) ? $rowcdsob->dt_obito : $this->dtObito;
								$this->docObito = (strlen($this->docObito) <= 0) ? $rowcdsob->nu_declaracao_obito : $this->docObito;
								$this->docObitoCds = $rowcdsob->nu_declaracao_obito;
							}
						}
					}
				}
				if (strlen($this->cnsResponsavelCi) > 0){
					if ($this->cnsResponsavel != $this->cnsResponsavelCi){
						if (strlen($this->cnsResponsavel) > 0){
							$this->cnsResponsavel .= "|".$this->cnsResponsavelCi;
						} else {
							$this->cnsResponsavel = $this->cnsResponsavelCi;
						}
					}
				}
				if (strlen($this->cpfResponsavelCi) > 0){
					if ($this->cpfResponsavel != $this->cpfResponsavelCi){
						if (strlen($this->cpfResponsavel) > 0){
							$this->cpfResponsavel .= "|".$this->cpfResponsavelCi;
						} else {
							$this->cpfResponsavel = $this->cpfResponsavelCi;
						}
					}
				}
			}	
		}
	}
}

class CidadaoFAT {
	public $cns;
	public $cpf;
	public $cns2;
	public $cpf2;
	public $totalEncontrado;
	public $ok;
	public $sql1;
	public $sql12;
	public $sql13;
	public $sql14;
	public $sql2;
	private $con;
	// ---------------------------------
	public $nome;
	public $dtNascimento;
	public $mae;
	public $pai;
	public $dtObito;
	public $dtAtCad;
	// .................................
	public $cnsResponsavel;
	public $cpfResponsavel;
	public $cor1;
	public $cor2;
	public $sexo1;
	public $celular;
	public $maC;
	public $ine;
	public $cnes;
	public $unidadeSaude;
	public $cnsProfissional;
	public $maD;
	public $cidadaoc;
	public $docObito;
	// -------------------------------------
	//    tb_fat_cad_individual
	// -------------------------------------
	public $cnsResponsavelCi;
	public $cpfResponsavelCi;
	public $tel1;
	public $tel2;
	public $dtObitoCi;
	public $docObitoCi;
	public $maCi;
	public $equipe;
	public $nomeProfissional;
	public $ativo;
	public $fichaInativa;
	public $faleceu;
	public $unificado;
	public $stDefi;
	public $stDefiAud;
	public $stDefiCog;
	public $stDefiOut;
	public $stDefiVis;
	public $stDefiFis;
	public $stHipertensao;
	public $stDiabete;
	public $stCancer;
	public $stGestante;
	public $stAcamado;
	public $stBeneficio;
	public $motBaixa;
	public $motBaixaDs;
	public $codimequipe;
	public $cboProfissional;
	public $cboNomeProfissional;
	// -------------------------------------
	//   tb_cds_cad_individual
	// -------------------------------------
	public $sexo2;
	public $email;
	public $cnesProfissional;
	public $docObitoCds;
	// -------------------------------------
	//   tratamento
	// -------------------------------------
	public $ma;
	
	private $cfat;

    public function __construct($con, $cfat) {
		$this->totalEncontrado = 0;
		$this->ok = false;
		$this->con = $con;
		$this->cfat = $cfat;
		
		$this->nome = '';
		$this->dtNascimento = '';
		$this->mae = '';
		$this->pai = '';
		$this->dtObito = '';
		$this->dtAtCad = '';
		$this->cnsResponsavel = '';
		$this->cpfResponsavel = '';
		$this->cor1 = '';
		$this->cor2 = '';
		$this->sexo1 = '';
		$this->celular = '';
		$this->maC = '';
		$this->ine = '';
		$this->cnes = '';
		$this->unidadeSaude = '';
		$this->cnsProfissional = '';
		$this->maD = '';
		$this->cnsResponsavelCi = '';
		$this->cpfResponsavelCi = '';
		$this->tel1 = '';
		$this->tel2 = '';
		$this->dtObitoCi = '';
		$this->maCi = '';
		$this->docObito = '';
		$this->docObitoCi = '';
		$this->docObitoCds = '';
		$this->equipe = '';
		$this->nomeProfissional = '';
		$this->ativo = '';
		$this->fichaInativa = '';
		$this->faleceu = '';
		$this->unificado = '';
		$this->stDefi = '';
		$this->stDefiAud = '';
		$this->stDefiCog = '';
		$this->stDefiOut = '';
		$this->stDefiVis = '';
		$this->stDefiFis = '';
		$this->stHipertensao = '';
		$this->stDiabete = '';
		$this->stCancer = '';
		$this->stGestante = '';
		$this->stAcamado = '';
		$this->stBeneficio = '';
		$this->motBaixa = '';
		$this->motBaixaDs = '';
		$this->codimequipe = '';
		$this->sexo2 = '';
		$this->email = '';
		$this->cboProfissional = '';
		$this->cboNomeProfissional = '';
		$this->ma = '';
		$this->cidadaoc = '';
		
		// ####################################################################################################################################################
		$sql_v1 = "
			SELECT
				tb1.co_cidadao,
				tb1.fatp_st_faleceu,
				tb_cidadao.nu_cns,
				tb_cidadao.nu_cpf,
				tb_cidadao.no_cidadao,
				tb_cidadao.dt_nascimento,
				tb_cidadao.no_mae,
				tb_cidadao.no_pai,
				tb_cidadao.dt_obito,
				tb_cidadao.st_faleceu,
				TO_CHAR(tb_cidadao.dt_atualizado, 'YYYYMMDD') as co_dim_tempo_c
			FROM
			(
				SELECT
					co_seq_fat_cidadao_pec, 
					co_cidadao,
					st_faleceu as fatp_st_faleceu
				FROM 
					tb_fat_cidadao_pec 
				WHERE 
					co_seq_fat_cidadao_pec = ?
			) AS tb1
			LEFT JOIN
				tb_cidadao
			ON tb_cidadao.co_seq_cidadao = tb1.co_cidadao
		";
		// ####################################################################################################################################################
		
		$rs1 = $this->con->prepare($sql_v1);
		$rs1->bindParam(1,$cfat);
		if($rs1->execute()){
			if($rs1->rowCount() > 0){
				$this->totalEncontrado = $rs1->rowCount();
				while($row1 = $rs1->fetch(PDO::FETCH_OBJ)){
					$this->ok = true;
					$this->cns = $row1->nu_cns;
					$this->cpf = $row1->nu_cpf;
					$this->nome = $row1->no_cidadao;
					$this->dtNascimento = $row1->dt_nascimento;
					$this->mae = $row1->no_mae;
					$this->pai = $row1->no_pai;
					$this->dtObito = $row1->dt_obito;
					$this->dtAtCad = $row1->co_dim_tempo_c;
					$this->cidadaoc = $row1->co_cidadao;
					$this->faleceu = $row1->st_faleceu;
					$this->faleceu = (strlen($this->faleceu) <= 0) ? $row1->fatp_st_faleceu : $this->faleceu;
				}
			}
		}
		
		// ####################################################################################################################################################
		$this->sql1 = "
		SELECT
			t8.co_cidadao AS fat_cidadaoc,
			t8.nu_cns AS fat_cns,
			t8.nu_cpf AS fat_cpf,
			t8.no_cidadao AS fat_nome,
			t8.dt_nascimento AS fat_dt_nascimento,
			t8.no_mae AS fat_mae,
			t8.no_pai AS fat_pai,
			t8.nu_cns_responsavel AS fat_cns_responsavel,
			t8.nu_cpf_responsavel AS fat_cpf_responsavel,
			t8.nu_cns_responsavel_ci AS fat_cns_responsavel_ci,
			t8.nu_cpf_responsavel_ci AS fat_cpf_responsavel_ci,
			t8.fat_cor1,
			t8.fat_cor2,
			t8.no_sexo AS fat_sexo1,
			t8.nu_telefone_celular AS fat_celular,
			t8.nu_telefone_residencial AS fat_tel1,
			t8.nu_telefone_contato AS fat_tel2,
			t8.dt_obito AS fat_dt_obito,
			t8.dt_obito_ci AS fat_dt_obito_ci,
			t8.co_dim_tempo AS fat_dt_at_cad,
			t8.co_dim_tempo_c AS fat_dt_at_cad_c,
			t8.nu_micro_area AS fat_ma_c,
			t8.nu_micro_area_ci AS fat_ma_ci,
			t8.nu_ine AS fat_ine,
			t8.no_equipe AS fat_equipe,
			t8.nu_cnes AS fat_cnes,
			t8.no_unidade_saude AS fat_unidade_saude,
			t8.nu_cns_prof AS fat_cns_profissional,
			t8.no_profissional AS fat_nome_profissional,
			t8.st_ativo AS fat_ativo,
			t8.st_ficha_inativa AS fat_ficha_inativa,
			t8.st_faleceu AS fat_faleceu,
			t8.fatp_st_faleceu,
			t8.st_unificado AS fat_unificado,
			t8.st_deficiencia AS fat_st_defi,
			t8.st_defi_auditiva AS fat_st_defi_aud,
			t8.st_defi_intelectual_cognitiva AS fat_st_defi_cog,
			t8.st_defi_outra AS fat_st_defi_out,
			t8.st_defi_visual AS fat_st_defi_vis,
			t8.st_defi_fisica AS fat_st_defi_fis,
			t8.st_hipertensao_arterial AS fat_st_hipertensao,
			t8.st_diabete AS fat_st_diabete,
			t8.st_cancer AS fat_st_cancer,
			t8.st_gestante AS fat_st_gestante,
			t8.st_acamado AS fat_st_acamado,
			t8.st_recebe_beneficio AS fat_st_beneficio,
			t8.co_dim_tipo_saida_cadastro AS fat_mot_baixa,
			t8.fat_mot_baixa_ds,
			t8.co_dim_equipe,
			t8.nu_cbo AS fat_cbo_prof,
			t8.no_cbo AS fat_cbo_nome_prof,
			t8.doc_obito,
			t8.doc_obito_ci
		FROM
		(
			SELECT
				t8a.*,
				tb_dim_cbo.nu_cbo,
				tb_dim_cbo.no_cbo
			FROM
			(
				SELECT
					t71.*,
					tb_dim_tipo_saida_cadastro.ds_dim_tipo_saida_cadastro AS fat_mot_baixa_ds
				FROM
				(
					SELECT
						t6.*,
						tb_raca_cor.no_identificador AS fat_cor1,
						tb_raca_cor.co_raca_cor_cadsus AS fat_cor2
					FROM
					(
						-- (05) -------------------------------------------------------------------------------------------
						SELECT
							t4.*,
							tb_dim_profissional.nu_cns AS nu_cns_prof,
							tb_dim_profissional.no_profissional
						FROM
						(
							-- (04) -------------------------------------------------------------------------------------------
							SELECT
								t3.*,
								tb_dim_unidade_saude.nu_cnes,
								tb_dim_unidade_saude.no_unidade_saude
							FROM
							(
								-- (03) -------------------------------------------------------------------------------------------
								SELECT
									t2.*,
									tb_dim_equipe.nu_ine,
									tb_dim_equipe.no_equipe
								FROM
								(
									-- (02) -------------------------------------------------------------------------------------------
									SELECT
										tb2.*,
										tb_fat_cad_individual.co_dim_unidade_saude,
										tb_fat_cad_individual.co_dim_equipe,
										tb_fat_cad_individual.co_dim_tempo,
										tb_fat_cad_individual.co_dim_cbo,
										tb_fat_cad_individual.co_seq_fat_cad_individual,
										tb_fat_cad_individual.nu_cns_responsavel AS nu_cns_responsavel_ci,
										tb_fat_cad_individual.nu_cpf_responsavel AS nu_cpf_responsavel_ci,
										tb_fat_cad_individual.st_deficiencia,
										tb_fat_cad_individual.st_defi_auditiva,
										tb_fat_cad_individual.st_defi_intelectual_cognitiva,
										tb_fat_cad_individual.st_defi_outra,
										tb_fat_cad_individual.st_defi_visual,
										tb_fat_cad_individual.st_defi_fisica,
										tb_fat_cad_individual.st_hipertensao_arterial,
										tb_fat_cad_individual.st_diabete,
										tb_fat_cad_individual.st_cancer,
										tb_fat_cad_individual.st_gestante,
										tb_fat_cad_individual.st_acamado,
										tb_fat_cad_individual.st_recebe_beneficio,
										tb_fat_cad_individual.dt_obito AS dt_obito_ci,
										tb_fat_cad_individual.nu_micro_area AS nu_micro_area_ci,
										tb_fat_cad_individual.st_ficha_inativa,
										tb_fat_cad_individual.co_dim_profissional,
										tb_fat_cad_individual.co_dim_tipo_saida_cadastro,
										tb_fat_cad_individual.nu_obito_do AS doc_obito_ci
									FROM
									(
										SELECT
											tb1.co_cidadao,
											tb1.co_seq_fat_cidadao_pec,
											tb1.st_faleceu as fatp_st_faleceu,
											tb_cidadao.no_cidadao,
											tb_cidadao.nu_cpf,
											tb_cidadao.nu_cns,
											tb_cidadao.dt_nascimento,
											tb_cidadao.no_mae,
											tb_cidadao.no_sexo,
											tb_cidadao.nu_micro_area,
											tb_cidadao.nu_cns_responsavel,
											tb_cidadao.nu_cpf_responsavel,
											tb_cidadao.st_ativo,
											tb_cidadao.dt_obito,
											tb_cidadao.st_faleceu,
											tb_cidadao.no_pai,
											tb_cidadao.st_unificado,
											tb_cidadao.nu_telefone_residencial,
											tb_cidadao.nu_telefone_celular,
											tb_cidadao.nu_telefone_contato,
											tb_cidadao.co_raca_cor,
											tb_cidadao.co_localidade_endereco,
											TO_CHAR(tb_cidadao.dt_atualizado, 'YYYYMMDD') as co_dim_tempo_c,
											tb_cidadao.nu_documento_obito AS doc_obito
										FROM
										(
											SELECT
												co_seq_fat_cidadao_pec, 
												co_cidadao,
												st_faleceu
											FROM 
												tb_fat_cidadao_pec 
											WHERE 
												co_seq_fat_cidadao_pec = ?
										) AS tb1
										LEFT JOIN
											tb_cidadao
										ON tb_cidadao.co_seq_cidadao = tb1.co_cidadao
									) AS tb2
									LEFT JOIN
										tb_fat_cad_individual
									ON tb_fat_cad_individual.co_fat_cidadao_pec = tb2.co_seq_fat_cidadao_pec
									ORDER BY co_seq_fat_cad_individual DESC
									LIMIT 1
									-- (02) -------------------------------------------------------------------------------------------
								) AS t2
								LEFT JOIN
									tb_dim_equipe
								ON t2.co_dim_equipe = tb_dim_equipe.co_seq_dim_equipe
								-- (03) -------------------------------------------------------------------------------------------
							) AS t3
							LEFT JOIN
								tb_dim_unidade_saude
							ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t3.co_dim_unidade_saude
							-- (04) -------------------------------------------------------------------------------------------
						) AS t4
						LEFT JOIN
							tb_dim_profissional
						ON tb_dim_profissional.co_seq_dim_profissional = t4.co_dim_profissional
						-- (05) -------------------------------------------------------------------------------------------
					) AS t6
					LEFT JOIN
						tb_raca_cor
					ON tb_raca_cor.co_raca_cor = t6.co_raca_cor
				) AS t71
				LEFT JOIN
					tb_dim_tipo_saida_cadastro
				ON tb_dim_tipo_saida_cadastro.co_seq_dim_tipo_saida_cadastro = t71.co_dim_tipo_saida_cadastro
			) AS t8a
			LEFT JOIN
				tb_dim_cbo
			ON tb_dim_cbo.co_seq_dim_cbo = t8a.co_dim_cbo
		) AS t8
		";
		// ####################################################################################################################################################
		$this->sql14 = "
			SELECT
				t2.*,
				tb_equipe.no_equipe
			FROM
			(
				SELECT 
					t1.*,
					tb_unidade_saude.no_unidade_saude
				FROM
				(
					SELECT 
						nu_cnes, 
						nu_ine
					FROM 
						tb_cidadao_vinculacao_equipe
					WHERE 
						co_cidadao = ?
					ORDER BY co_seq_cidadao_vinculacao_eqp DESC
					LIMIT 1
				) AS t1
				LEFT JOIN
					tb_unidade_saude
				ON tb_unidade_saude.nu_cnes = t1.nu_cnes
			) AS t2
			LEFT JOIN
				tb_equipe
			ON tb_equipe.nu_ine = t2.nu_ine
		";
		// ####################################################################################################################################################

	}
	public function dados(){
		if ($this->ok){
			$rs1 = $this->con->prepare($this->sql1);
			$rs1->bindParam(1,$this->cfat);
			if($rs1->execute()){
				if($rs1->rowCount() > 0){
					$this->totalEncontrado = $rs1->rowCount();
					while($row1 = $rs1->fetch(PDO::FETCH_OBJ)){
						// -------------------------------------
						$this->ok = true;
						
						$this->cns = $row1->fat_cns;
						$this->cpf = $row1->fat_cpf;
						if ($row1->fat_unificado == 1){
							$sel_dup = "
								SELECT DISTINCT ON (nu_cns, nu_cpf)
									nu_cns,
									nu_cpf
								FROM 
									tb_cidadao_grupo
								WHERE 
									co_cidadao_master = ?
							";
							$rsd = $this->con->prepare($sel_dup);
							$rsd->bindParam(1,$this->cfat);
							if($rsd->execute()){
								if($rsd->rowCount() > 0){
									while($rowd = $rsd->fetch(PDO::FETCH_OBJ)){
										if ($rowd->nu_cns != $row1->fat_cns){
											$this->cns2 = $rowd->nu_cns;
										}
										if ($rowd->nu_cpf != $row1->fat_cpf){
											$this->cpf2 = $rowd->nu_cpf;
										}
									}
								}
							}
						}
						$this->nome = $row1->fat_nome;
						$this->dtNascimento = $row1->fat_dt_nascimento;
						$this->mae = $row1->fat_mae;
						$this->pai = $row1->fat_pai;
						$this->cnsResponsavel = $row1->fat_cns_responsavel;
						$this->cpfResponsavel = $row1->fat_cpf_responsavel;
						$this->cor1 = $row1->fat_cor1;
						$this->cor2 = $row1->fat_cor2;
						$this->sexo1 = $row1->fat_sexo1;
						$this->celular = $row1->fat_celular;
						$this->dtObito = $row1->fat_dt_obito;
						$this->docObito = $row1->doc_obito;
						$this->dtAtCad = $row1->fat_dt_at_cad;
						$this->maC = $row1->fat_ma_c;
						$this->ine = $row1->fat_ine;
						$this->cnes = $row1->fat_cnes;
						$this->unidadeSaude = $row1->fat_unidade_saude;
						$this->cnsProfissional = $row1->fat_cns_profissional;
						$this->cidadaoc = $row1->fat_cidadaoc;
						// -------------------------------------
						$this->cnsResponsavelCi = $row1->fat_cns_responsavel_ci;
						$this->cpfResponsavelCi = $row1->fat_cpf_responsavel_ci;
						$this->tel1 = $row1->fat_tel1;
						$this->tel2 = $row1->fat_tel2;
						$this->dtObitoCi = $row1->fat_dt_obito_ci;
						$this->docObitoCi = $row1->doc_obito_ci;
						$this->maCi = $row1->fat_ma_ci;
						$this->equipe = $row1->fat_equipe;
						$this->nomeProfissional = $row1->fat_nome_profissional;
						$this->ativo = $row1->fat_ativo;
						$this->fichaInativa = $row1->fat_ficha_inativa;
						$this->faleceu = $row1->fat_faleceu;
						$this->faleceu = (strlen($this->faleceu) <= 0) ? $row1->fatp_st_faleceu : $this->faleceu;
						$this->unificado = $row1->fat_unificado;
						$this->stDefi = $row1->fat_st_defi;
						$this->stDefiAud = $row1->fat_st_defi_aud;
						$this->stDefiCog = $row1->fat_st_defi_cog;
						$this->stDefiOut = $row1->fat_st_defi_out;
						$this->stDefiVis = $row1->fat_st_defi_vis;
						$this->stDefiFis = $row1->fat_st_defi_fis;
						$this->stHipertensao = $row1->fat_st_hipertensao;
						$this->stDiabete = $row1->fat_st_diabete;
						$this->stCancer = $row1->fat_st_cancer;
						$this->stGestante = $row1->fat_st_gestante;
						$this->stAcamado = $row1->fat_st_acamado;
						$this->stBeneficio = $row1->fat_st_beneficio;
						$this->motBaixa = $row1->fat_mot_baixa;
						$this->motBaixaDs = $row1->fat_mot_baixa_ds;
						$this->codimequipe = $row1->co_dim_equipe;
						$this->cboProfissional = $row1->fat_cbo_prof;
						$this->cboNomeProfissional = $row1->fat_cbo_nome_prof;
						if (strlen($this->cidadaoc) > 0){
							// -------------------------------------
							$rse = $this->con->prepare($this->sql14);
							$rse->bindParam(1,$this->cidadaoc);
							if($rse->execute()){
								if($rse->rowCount() > 0){
									while($rowe = $rse->fetch(PDO::FETCH_OBJ)){
										$this->cnes = (strlen($this->cnes) <= 0) ? $rowe->nu_cnes : $this->cnes;
										$this->ine = (strlen($this->ine) <= 0) ? $rowe->nu_ine : $this->ine;
										$this->equipe = (strlen($this->equipe) <= 0) ? $rowe->no_equipe : $this->equipe;
										$this->unidadeSaude = (strlen($this->unidadeSaude) <= 0) ? $rowe->no_unidade_saude : $this->unidadeSaude;
									}
								}
							}
						}
					}
				}
			}
			if ($this->ok){
				if (strlen($this->maC) > 0){
					$this->ma = $this->maC;
				}
				if (strlen($this->maCi) > 0){
					if ($this->ma != $this->maCi){
						if (strlen($this->ma) > 0){
							$this->ma .= "|".$this->maCi;
						} else {
							$this->ma = $this->maCi;
						}
					}
				}
				if (strlen($this->maD) > 0){
					if ($this->ma != $this->maD){
						if (strlen($this->ma) > 0){
							$this->ma .= "|".$this->maD;
						} else {
							$this->ma = $this->maD;
						}
					}
				}
				if (strlen($this->dtObitoCi) > 0){
					if ($this->dtObito != $this->dtObitoCi){
						if (strlen($this->dtObito) > 0){
							$this->dtObito .= "|".$this->dtObitoCi;
						} else {
							$this->dtObito = $this->dtObitoCi;
						}
					}
				}
				if (strlen($this->docObitoCi) > 0){
					if ($this->docObito != $this->docObitoCi){
						if (strlen($this->docObito) > 0){
							$this->docObito .= "|".$this->docObitoCi;
						} else {
							$this->docObito = $this->docObitoCi;
						}
					}
				}
				if (strlen($this->docObito) <= 0 || strlen($this->dtObito) <= 0){
					$rscdsob = $this->con->prepare("select date(dt_obito) as dt_obito, nu_declaracao_obito from tb_cds_cad_individual where no_cidadao = ? and date(dt_nascimento) = ? and dt_obito notnull order by co_seq_cds_cad_individual desc limit 1");
					$rscdsob->bindParam(1,$this->nome);
					$rscdsob->bindParam(2,$this->dtNascimento);
					if($rscdsob->execute()){
						if($rscdsob->rowCount() > 0){
							while($rowcdsob = $rscdsob->fetch(PDO::FETCH_OBJ)){
								$this->dtObito = (strlen($this->dtObito) <= 0) ? $rowcdsob->dt_obito : $this->dtObito;
								$this->docObito = (strlen($this->docObito) <= 0) ? $rowcdsob->nu_declaracao_obito : $this->docObito;
								$this->docObitoCds = $rowcdsob->nu_declaracao_obito;
							}
						}
					}
				}
				if (strlen($this->cnsResponsavelCi) > 0){
					if ($this->cnsResponsavel != $this->cnsResponsavelCi){
						if (strlen($this->cnsResponsavel) > 0){
							$this->cnsResponsavel .= "|".$this->cnsResponsavelCi;
						} else {
							$this->cnsResponsavel = $this->cnsResponsavelCi;
						}
					}
				}
				if (strlen($this->cpfResponsavelCi) > 0){
					if ($this->cpfResponsavel != $this->cpfResponsavelCi){
						if (strlen($this->cpfResponsavel) > 0){
							$this->cpfResponsavel .= "|".$this->cpfResponsavelCi;
						} else {
							$this->cpfResponsavel = $this->cpfResponsavelCi;
						}
					}
				}
			}	
		}
	}
}

class Endereco {
	public $cns;
	public $cpf;
	public $cnsResponsavel;
	public $cpfResponsavel;
	public $ok;
	public $nt;
	public $sql0;
	public $sql1;
	public $sql2;
	public $sqlx;
	private $con;
	// ---------------------------------
	public $nome;
	public $dtNascimento;
	public $mae;
	public $tipoLogradouro;
	public $logradouro;
	public $numero;
	public $complemento;
	public $bairro;
	public $cep;
	public $cidade;
	public $ibge;
	public $uf;
	public $estado;
	public $latitude;
	public $longitude;

    public function __construct($con, $nome, $mae, $dtNascimento, $cns, $cpf, $cnsResponsavel, $cpfResponsavel, $nt = false) {
		$this->ok = false;
		$this->nt = $nt;
		$this->con = $con;
		$this->nome = $nome;
		$this->dtNascimento = $dtNascimento;
		$this->mae = $mae;
		$this->cns = $cns;
		$this->cpf = $cpf;
		$this->cnsResponsavel = $cnsResponsavel;
		$this->cpfResponsavel = $cpfResponsavel;
		$this->tipoLogradouro = '';
		$this->logradouro = '';
		$this->numero = '';
		$this->complemento = '';
		$this->bairro = '';
		$this->cep = '';
		$this->cidade = '';
		$this->ibge = '';
		$this->uf = '';
		$this->estado = '';
		$this->latitude = '';
		$this->longitude = '';
		// ####################################################################################################################################################
		$this->sql0 = "
			SELECT
				*
			FROM
			(
				SELECT
					t2.*,
					tb_dim_municipio.no_municipio,
					tb_dim_municipio.co_ibge
				FROM
				(
					SELECT
						t1.co_dim_tempo,
						t1.co_fat_cad_domiciliar,
						tb_fat_cad_domiciliar.nu_latitude,
						tb_fat_cad_domiciliar.nu_longitude,
						tb_fat_cad_domiciliar.co_dim_municipio
					FROM
					(
						SELECT
							co_dim_tempo,
							co_fat_cad_domiciliar
						FROM 
							tb_fat_cad_dom_familia
						WHERE
							(nu_cns_responsavel = ? OR nu_cpf_responsavel = ?) OR
							(nu_cns_responsavel = ? OR nu_cpf_responsavel = ?)
					) AS t1
					LEFT JOIN
						tb_fat_cad_domiciliar
					ON tb_fat_cad_domiciliar.co_seq_fat_cad_domiciliar = t1.co_fat_cad_domiciliar
				) AS t2
				JOIN 
					tb_dim_municipio
				ON tb_dim_municipio.co_seq_dim_municipio = t2.co_dim_municipio
			) AS t3
			ORDER BY co_dim_tempo DESC
			LIMIT 1
		";
		// ####################################################################################################################################################
		$this->sqlx = "
			SELECT
				t3.no_logradouro,
				t3.nu_domicilio,
				t3.ds_complemento,
				t3.no_bairro,
				t3.nu_cep,
				t3.nu_latitude,
				t3.nu_longitude,
				t3.no_tipo_logradouro,
				tb_uf.no_uf,
				tb_uf.sg_uf
			FROM
			(
				SELECT
					t2.*,
					tb_tipo_logradouro.no_tipo_logradouro
				FROM
				(
					SELECT 
						t1.*,
						tb_cds_cad_domiciliar.no_logradouro,
						tb_cds_cad_domiciliar.nu_domicilio,
						tb_cds_cad_domiciliar.ds_complemento,
						tb_cds_cad_domiciliar.no_bairro,
						tb_cds_cad_domiciliar.co_municipio,
						tb_cds_cad_domiciliar.nu_cep,
						tb_cds_cad_domiciliar.co_uf,
						tb_cds_cad_domiciliar.nu_latitude,
						tb_cds_cad_domiciliar.nu_longitude,
						tb_cds_cad_domiciliar.tp_logradouro
					FROM
					(
						SELECT
							co_cds_cad_domiciliar
						FROM
							tb_cds_domicilio_familia
						WHERE
							(nu_cartao_sus = ? OR nu_cpf_cidadao = ?) OR
							(nu_cartao_sus = ? OR nu_cpf_cidadao = ?)
						ORDER BY co_seq_cds_domicilio_familia DESC
						LIMIT 1
					) AS t1
					LEFT JOIN tb_cds_cad_domiciliar
					ON tb_cds_cad_domiciliar.co_seq_cds_cad_domiciliar = t1.co_cds_cad_domiciliar
				) AS t2
				LEFT JOIN tb_tipo_logradouro
				ON tb_tipo_logradouro.co_tipo_logradouro = t2.tp_logradouro
			) AS t3
			LEFT JOIN tb_uf
			ON tb_uf.co_uf = t3.co_uf
		";
		// ####################################################################################################################################################
		$this->sql1 = "
			SELECT
				t4.no_logradouro,
				t4.nu_domicilio,
				t4.ds_complemento,
				t4.no_bairro,
				t4.nu_cep,
				t4.nu_latitude,
				t4.nu_longitude,
				t4.no_tipo_logradouro,
				t4.no_uf,
				t4.sg_uf,
				tb_localidade.no_localidade,
				tb_localidade.co_ibge
			FROM
			(
				SELECT
					t3.*,
					tb_uf.sg_uf,
					tb_uf.no_uf
				FROM
				(
					SELECT 
						t2.*,
						tb_tipo_logradouro.no_tipo_logradouro
					FROM
					(
						SELECT 
							t1.*,
							tb_cds_cad_domiciliar.no_logradouro,
							tb_cds_cad_domiciliar.nu_domicilio,
							tb_cds_cad_domiciliar.ds_complemento,
							tb_cds_cad_domiciliar.no_bairro,
							tb_cds_cad_domiciliar.co_municipio,
							tb_cds_cad_domiciliar.nu_cep,
							tb_cds_cad_domiciliar.co_uf,
							tb_cds_cad_domiciliar.nu_latitude,
							tb_cds_cad_domiciliar.nu_longitude,
							tb_cds_cad_domiciliar.tp_logradouro
						FROM
						(
							SELECT
								co_cds_cad_domiciliar
							FROM 
								tb_cds_domicilio_familia 
							WHERE 
								(nu_cartao_sus = ? OR nu_cpf_cidadao = ?) OR 
								(nu_cartao_sus = ? OR nu_cpf_cidadao = ?)
							ORDER BY co_seq_cds_domicilio_familia DESC 
							LIMIT 1
						) AS t1
						LEFT JOIN
							tb_cds_cad_domiciliar
						ON tb_cds_cad_domiciliar.co_seq_cds_cad_domiciliar = t1.co_cds_cad_domiciliar
					) AS t2
					LEFT JOIN
						tb_tipo_logradouro
					ON tb_tipo_logradouro.co_tipo_logradouro = t2.tp_logradouro
				) AS t3
				LEFT JOIN
					tb_uf
				ON tb_uf.co_uf = t3.co_uf
			) AS t4
			LEFT JOIN
				tb_localidade
			ON tb_localidade.co_localidade = t4.co_municipio
		";
		// ####################################################################################################################################################
		$query_mae = "";
		if (strlen($this->mae) > 0){
			$query_mae = "AND translate(no_mae_cidadao,'áàâãäåaaaÁÂÃÄÅAAAÀéèêëeeeeeEEEÉEEÈìíîïìiiiÌÍÎÏÌIIIóôõöoooòÒÓÔÕÖOOOùúûüuuuuÙÚÛÜUUUUçÇñÑýÝ','aaaaaaaaaAAAAAAAAAeeeeeeeeeEEEEEEEiiiiiiiiIIIIIIIIooooooooOOOOOOOOuuuuuuuuUUUUUUUUcCnNyY') LIKE '".$this->tirap($this->mae)."%'";
		}
		$this->sql2 = "
			SELECT
				t4.nu_celular_cidadao,
				t4.nu_cns_cidadao,
				t4.nu_cpf_cidadao,
				t4.nu_cartao_sus_responsavel,
				t4.nu_cpf_responsavel,
				t4.no_logradouro,
				t4.nu_domicilio,
				t4.ds_complemento,
				t4.no_bairro,
				t4.nu_cep,
				t4.nu_micro_area,
				t4.nu_latitude,
				t4.nu_longitude,
				t4.no_tipo_logradouro,
				tb_uf.no_uf,
				tb_uf.sg_uf
			FROM
			(
				SELECT
					t3.*,
					tb_tipo_logradouro.no_tipo_logradouro
				FROM
				(
					SELECT 
						t2.*,
						tb_cds_cad_domiciliar.no_logradouro,
						tb_cds_cad_domiciliar.nu_domicilio,
						tb_cds_cad_domiciliar.ds_complemento,
						tb_cds_cad_domiciliar.no_bairro,
						tb_cds_cad_domiciliar.co_municipio,
						tb_cds_cad_domiciliar.nu_cep,
						tb_cds_cad_domiciliar.co_uf,
						tb_cds_cad_domiciliar.nu_micro_area,
						tb_cds_cad_domiciliar.nu_latitude,
						tb_cds_cad_domiciliar.nu_longitude,
						tb_cds_cad_domiciliar.tp_logradouro
					FROM
					(
						SELECT
							t1.*,
							tb_cds_domicilio_familia.co_cds_cad_domiciliar
						FROM
						(
							SELECT 
								nu_celular_cidadao, 
								nu_cns_cidadao,
								nu_cpf_cidadao,
								nu_cartao_sus_responsavel,
								nu_cpf_responsavel
							FROM
								tb_cds_cad_individual
							WHERE
								translate(no_cidadao,'áàâãäåaaaÁÂÃÄÅAAAÀéèêëeeeeeEEEÉEEÈìíîïìiiiÌÍÎÏÌIIIóôõöoooòÒÓÔÕÖOOOùúûüuuuuÙÚÛÜUUUUçÇñÑýÝ','aaaaaaaaaAAAAAAAAAeeeeeeeeeEEEEEEEiiiiiiiiIIIIIIIIooooooooOOOOOOOOuuuuuuuuUUUUUUUUcCnNyY') LIKE '".$this->tirap($this->nome)."%' 
								AND (dt_nascimento >= '".$this->dtNascimento." 00:00:00' AND dt_nascimento <= '".$this->dtNascimento." 23:59:59') 
								".$query_mae."
							ORDER BY co_seq_cds_cad_individual DESC LIMIT 1
						) AS t1
						LEFT JOIN tb_cds_domicilio_familia
						ON tb_cds_domicilio_familia.nu_cartao_sus = t1.nu_cns_cidadao OR tb_cds_domicilio_familia.nu_cpf_cidadao = t1.nu_cpf_cidadao
						ORDER BY tb_cds_domicilio_familia.co_seq_cds_domicilio_familia DESC LIMIT 1
					) AS t2
					LEFT JOIN tb_cds_cad_domiciliar
					ON tb_cds_cad_domiciliar.co_seq_cds_cad_domiciliar = t2.co_cds_cad_domiciliar
				) AS t3
				LEFT JOIN tb_tipo_logradouro
				ON tb_tipo_logradouro.co_tipo_logradouro = t3.tp_logradouro
			) AS t4
			LEFT JOIN tb_uf
			ON tb_uf.co_uf = t4.co_uf
		";
		// ####################################################################################################################################################
		
		// -------------------------------------------------------------------------------------
		$rsl = $this->con->prepare($this->sql0);
		$rsl->bindParam(1,$this->cns);
		$rsl->bindParam(2,$this->cpf);
		$rsl->bindParam(3,$this->cnsResponsavel);
		$rsl->bindParam(4,$this->cpfResponsavel);
		if($rsl->execute()){
			if($rsl->rowCount() > 0){
				while($rowl = $rsl->fetch(PDO::FETCH_OBJ)){
					$this->latitude = $rowl->nu_latitude;
					$this->longitude = $rowl->nu_longitude;
					$this->cidade = $rowl->no_municipio;
					$this->ibge = $rowl->co_ibge;
				}
			}
		}
		// -------------------------------------------------------------------------------------
		$rsr = $this->con->prepare($this->sql1);
		$rsr->bindParam(1,$this->cns);
		$rsr->bindParam(2,$this->cpf);
		$rsr->bindParam(3,$this->cnsResponsavel);
		$rsr->bindParam(4,$this->cpfResponsavel);
		if($rsr->execute()){
			if($rsr->rowCount() > 0){
				while($rowsr = $rsr->fetch(PDO::FETCH_OBJ)){
					if (strlen($rowsr->no_logradouro) > 0){
						$this->ok = true;
						$this->tipoLogradouro = $rowsr->no_tipo_logradouro;
						$this->logradouro = $rowsr->no_logradouro;
						$this->numero = $rowsr->nu_domicilio;
						$this->complemento = $rowsr->ds_complemento;
						$this->bairro = $rowsr->no_bairro;
						$this->uf = $rowsr->sg_uf;
						if (strlen($this->latitude) > 0){
							if ($this->latitude == 0){
								$this->latitude = $rowsr->nu_latitude;
							}
						} else {
							$this->latitude = $rowsr->nu_latitude;
						}
						if (strlen($this->longitude) > 0){
							if ($this->longitude == 0){
								$this->longitude = $rowsr->nu_longitude;
							}
						} else {
							$this->longitude = $rowsr->nu_longitude;
						}
						if (strlen($this->cidade) <= 0){
							$this->cidade = $rowsr->no_localidade;
						}
						if (strlen($this->ibge) <= 0){
							$this->ibge = $rowsr->co_ibge;
						}
					}
				}
			}
		}
		// -------------------------------------------------------------------------------------
		if (!$this->ok && $this->nt){
			if (strlen($this->dtNascimento) == 10){
				$rsl = $this->con->prepare($this->sql2);
				if($rsl->execute()){
					if($rsl->rowCount() > 0){
						while($rowsl = $rsl->fetch(PDO::FETCH_OBJ)){
							if (strlen($rowsl->no_logradouro) > 0){
								$this->ok = true;
								$this->tipoLogradouro = $rowsl->no_tipo_logradouro;
								$this->logradouro = $rowsl->no_logradouro;
								$this->numero = $rowsl->nu_domicilio;
								$this->complemento = $rowsl->ds_complemento;
								$this->bairro = $rowsl->no_bairro;
								$this->uf = $rowsl->sg_uf;
								if (strlen($this->latitude) > 0){
									if ($this->latitude == 0){
										$this->latitude = $rowsl->nu_latitude;
									}
								} else {
									$this->latitude = $rowsl->nu_latitude;
								}
								if (strlen($this->longitude) > 0){
									if ($this->longitude == 0){
										$this->longitude = $rowsl->nu_longitude;
									}
								} else {
									$this->longitude = $rowsl->nu_longitude;
								}
							}
						}
					}
				}
			}
		}
	}
	public function tirap($str) {
		$map = array();
		$map[0][0]  = "Ã"; $map[0][1]  = "A";
		$map[1][0]  = "Â"; $map[1][1]  = "A";
		$map[2][0]  = "Á"; $map[2][1]  = "A";
		$map[3][0]  = "À"; $map[3][1]  = "A";
		$map[4][0]  = "Ä"; $map[4][1]  = "A";
		$map[5][0]  = "ã"; $map[5][1]  = "a";
		$map[6][0]  = "á"; $map[6][1]  = "a";
		$map[7][0]  = "à"; $map[7][1]  = "a";
		$map[8][0]  = "ä"; $map[8][1]  = "a";
		$map[9][0]  = "Ê"; $map[9][1]  = "E";
		$map[10][0] = "É"; $map[10][1] = "E";
		$map[11][0] = "È"; $map[11][1] = "E";
		$map[12][0] = "Ë"; $map[12][1] = "E";
		$map[13][0] = "ê"; $map[13][1] = "e";
		$map[14][0] = "é"; $map[14][1] = "e";
		$map[15][0] = "è"; $map[15][1] = "e";
		$map[16][0] = "ë"; $map[16][1] = "e";
		$map[17][0] = "Î"; $map[17][1] = "I";
		$map[18][0] = "Í"; $map[18][1] = "I";
		$map[19][0] = "Ì"; $map[19][1] = "I";
		$map[20][0] = "Ï"; $map[20][1] = "I";
		$map[21][0] = "î"; $map[21][1] = "i";
		$map[22][0] = "í"; $map[22][1] = "i";
		$map[23][0] = "ì"; $map[23][1] = "i";
		$map[24][0] = "ï"; $map[24][1] = "i";
		$map[25][0] = "Õ"; $map[25][1] = "O";
		$map[26][0] = "Ô"; $map[26][1] = "O";
		$map[27][0] = "Ó"; $map[27][1] = "O";
		$map[28][0] = "Ò"; $map[28][1] = "O";
		$map[29][0] = "Ö"; $map[29][1] = "O";
		$map[30][0] = "õ"; $map[30][1] = "o";
		$map[31][0] = "ó"; $map[31][1] = "o";
		$map[32][0] = "ò"; $map[32][1] = "o";
		$map[33][0] = "ö"; $map[33][1] = "o";
		$map[34][0] = "ô"; $map[34][1] = "o";
		$map[35][0] = "â"; $map[35][1] = "a";
		$map[36][0] = "Ç"; $map[36][1] = "C";
		$map[37][0] = "ç"; $map[37][1] = "c";
		$map[38][0] = "Ñ"; $map[38][1] = "N";
		$map[39][0] = "ñ"; $map[39][1] = "n";
		$map[40][0] = "Û"; $map[40][1] = "U";
		$map[41][0] = "Ú"; $map[41][1] = "U";
		$map[42][0] = "Ù"; $map[42][1] = "U";
		$map[43][0] = "Ü"; $map[43][1] = "U";
		$map[44][0] = "û"; $map[44][1] = "u";
		$map[45][0] = "ú"; $map[45][1] = "u";
		$map[46][0] = "ù"; $map[46][1] = "u";
		$map[47][0] = "ü"; $map[47][1] = "u";
		$map[48][0] = "–"; $map[48][1] = "";
		$map[49][0] = "ª"; $map[49][1] = "";
		$map[50][0] = "º"; $map[50][1] = "";
		$map[51][0] = "°"; $map[51][1] = "";
		$map[52][0] = "“"; $map[52][1] = "";
		$map[53][0] = "”"; $map[53][1] = "";
		$map[54][0] = "'"; $map[54][1] = "";
		$map[55][0] = "´"; $map[55][1] = "";
		$map[56][0] = "`"; $map[56][1] = "";
		for ($i=0;$i<count($map);$i++){
			$str = str_replace($map[$i][0], $map[$i][1], $str);
		}
		return $str;
	}
}

class CidadaosSISABD {
	public $totalEncontrado;
	public $ok;
	public $sql;
	public $cidadaos = array();
	public $ref;
	public $idu;
	public $ibge;
	public $quadrimestre;
	public $tabela;
	private $con;
    public function __construct($con, $ref, $idu, $ibge, $quadrimestre, $tabela) {
		$this->totalEncontrado = 0;
		$this->ok = false;
		$this->sql = '';
		$this->cidadaos = array();
		$this->ref = $ref;
		$this->idu = $idu;
		$this->ibge = $ibge;
		$this->quadrimestre = $quadrimestre;
		$this->con = $con;
		$this->tabela = $tabela;
		if ($this->ref != ''){
			$this->sql = "SELECT * FROM ".$this->tabela." WHERE id = '".$this->idu."' AND ibge = '".$this->ibge."' AND ref = '".$this->ref."' AND quadrimestre = '".$this->quadrimestre."'";
		}
	}
    public function todos() {
		if ($this->ref != ''){
			$rs = $this->con->query($this->sql);
			$conta_array = 0;
			if($rs->execute()){
				$this->totalEncontrado = $rs->rowCount();
				if($this->totalEncontrado > 0){
					$this->ok = true;
					while($rows = $rs->fetch(PDO::FETCH_OBJ)){
						$this->cidadaos[$conta_array]['cns'] = trim($rows->cns);
						$this->cidadaos[$conta_array]['cpf'] = trim($rows->cpf);
						$this->cidadaos[$conta_array]['cidadao'] = trim($rows->cidadao);
						$this->cidadaos[$conta_array]['cidadao2'] = '';
						$this->cidadaos[$conta_array]['cidadaoc'] = trim($rows->cidadaoc);
						if (strlen($this->cidadaos[$conta_array]['cidadao']) <= 0){
							$this->cidadaos[$conta_array]['cidadao'] = '0';
						}
						if (strlen($this->cidadaos[$conta_array]['cidadaoc']) <= 0){
							$this->cidadaos[$conta_array]['cidadaoc'] = '0';
						}
						$this->cidadaos[$conta_array]['ine'] = $rows->ine;
						$this->cidadaos[$conta_array]['cnes'] = $rows->cnes;
						$this->cidadaos[$conta_array]['nome'] = $rows->nome;
						$this->cidadaos[$conta_array]['dtnas'] = $rows->dtnas;
						$this->cidadaos[$conta_array]['local'] = $rows->local;
						// ref GES
						/*
						$this->cidadaos[$conta_array]['dtini'] = $rows->dtini;
						$this->cidadaos[$conta_array]['dtfin'] = $rows->dtfin;
						$this->cidadaos[$conta_array]['aborto'] = trim($rows->aborto);
						*/
						$conta_array++;
					}
				}
			}
		}
	}
    public function total() {
		if ($this->ref != ''){
			$rs = $this->con->query($this->sql);
			if($rs->execute()){
				$this->totalEncontrado = $rs->rowCount();
				if($this->totalEncontrado > 0){
					$this->ok = true;
				}
			}
		}
    }
}

class CidadaosSISABC {
	public $totalEncontrado;
	public $ok;
	public $sql;
	public $cidadaos = array();
	public $indicador;
	public $idu;
	public $ibge;
	private $con;
	public $tabela;
    public function __construct($con, $indicador, $idu, $ibge, $tabela) {
		$this->totalEncontrado = 0;
		$this->ok = false;
		$this->sql = '';
		$this->cidadaos = array();
		$this->indicador = $indicador;
		$this->idu = $idu;
		$this->ibge = $ibge;
		$this->tabela = $tabela;
		$this->con = $con;
		if ($this->indicador != ''){
			$this->sql = "SELECT * FROM ".$this->tabela." WHERE id = '".$this->idu."' AND ibge = '".$this->ibge."' AND indicador = '".$this->indicador."'";
		}
	}
    public function todos() {
		if ($this->indicador != ''){
			$rs = $this->con->query($this->sql);
			$conta_array = 0;
			if($rs->execute()){
				$this->totalEncontrado = $rs->rowCount();
				if($this->totalEncontrado > 0){
					$this->ok = true;
					while($rows = $rs->fetch(PDO::FETCH_OBJ)){
						$this->cidadaos[$conta_array]['cns'] = trim($rows->cns);
						$this->cidadaos[$conta_array]['cpf'] = trim($rows->cpf);
						$this->cidadaos[$conta_array]['cidadao'] = trim($rows->cidadao);
						$this->cidadaos[$conta_array]['cidadao2'] = '';
						$this->cidadaos[$conta_array]['cidadaoc'] = trim($rows->cidadaoc);
						if (strlen($this->cidadaos[$conta_array]['cidadao']) <= 0){
							$this->cidadaos[$conta_array]['cidadao'] = '0';
						}
						if (strlen($this->cidadaos[$conta_array]['cidadaoc']) <= 0){
							$this->cidadaos[$conta_array]['cidadaoc'] = '0';
						}
						$this->cidadaos[$conta_array]['ine'] = $rows->equipe;
						$this->cidadaos[$conta_array]['nome'] = $rows->nome;
						$this->cidadaos[$conta_array]['dtnas'] = $rows->dtn;
						$this->cidadaos[$conta_array]['local'] = $rows->local;
						$this->cidadaos[$conta_array]['cnes'] = $rows->cnes;
						// ref GES
						/*
						$this->cidadaos[$conta_array]['dtini'] = $rows->dtini;
						$this->cidadaos[$conta_array]['dtfin'] = $rows->dtfin;
						$this->cidadaos[$conta_array]['aborto'] = trim($rows->aborto);
						*/
						$conta_array++;
					}
				}
			}
		}
	}
    public function total() {
		if ($this->indicador != ''){
			$rs = $this->con->query($this->sql);
			if($rs->execute()){
				$this->totalEncontrado = $rs->rowCount();
				if($this->totalEncontrado > 0){
					$this->ok = true;
				}
			}
		}
    }
}

class CidadaoCC {
	public $ok;
	public $sql_cidadao;
	public $sql_cidadaoc;
	public $cidadao;
	public $cidadaoc;
	public $cns;
	public $cpf;
	private $con;
    public function __construct($con, $cns, $cpf) {
		$this->ok = false;
		$this->sql_cidadao = '';
		$this->sql_cidadaoc = '';
		$this->cidadao = '0';
		$this->cidadaoc = '0';
		$this->con = $con;
		$this->cns = $cns;
		$this->cpf = $cpf;
		// ####################################################################################################################################################
		$this->sql_cidadao = "
			SELECT
				co_seq_fat_cidadao_pec
			FROM 
				tb_fat_cidadao_pec 
			WHERE 
				nu_cns = ? OR nu_cpf_cidadao = ?
			ORDER BY co_seq_fat_cidadao_pec DESC 
			LIMIT 1
		";
		// ####################################################################################################################################################
		$this->sql_cidadaoc = "
			SELECT
				co_seq_cidadao
			FROM
				tb_cidadao
			WHERE
				nu_cns = ? OR nu_cpf = ?
			ORDER BY co_seq_cidadao DESC
			LIMIT 1
		";
		// ####################################################################################################################################################
	}
    public function dados() {
		$rs_cidadao = $this->con->prepare($this->sql_cidadao);
		$rs_cidadao->bindParam(1,$this->cns);
		$rs_cidadao->bindParam(2,$this->cpf);
		if($rs_cidadao->execute()){
			if($rs_cidadao->rowCount() > 0){
				$this->ok = true;
				while($rows_cidadao = $rs_cidadao->fetch(PDO::FETCH_OBJ)){
					$this->cidadao = $rows_cidadao->co_seq_fat_cidadao_pec;
				}
			}
		}
		$rs_cidadaoc = $this->con->prepare($this->sql_cidadaoc);
		$rs_cidadaoc->bindParam(1,$this->cns);
		$rs_cidadaoc->bindParam(2,$this->cpf);
		if($rs_cidadaoc->execute()){
			if($rs_cidadaoc->rowCount() > 0){
				$this->ok = true;
				while($rows_cidadaoc = $rs_cidadaoc->fetch(PDO::FETCH_OBJ)){
					$this->cidadaoc = $rows_cidadaoc->co_seq_cidadao;
				}
			}
		}
	}
}


class Cidadaos {
	public $sexo;
	public $idi;
	public $idf;
	public $dti;
	public $dtf;
	public $tpi;
	public $ndti;
	public $ndtf;
	public $filt;
	public $cid2;
	public $totalEncontrado;
	public $ok;
	// -------------------------------------
	public $cidadaos = array();
	public $sql1;
	public $sql2;
	public $sql3;
	public $sql4;
	private $con;

    public function __construct($con, $sexo = 'T', $idi = 0, $idf = 0, $dti = 0, $dtf = 0, $tpi = 1, $filt = null, $cid2 = false) {
		$this->totalEncontrado = 0;
		$this->ok = false;
		$this->con = $con;
        $this->sexo = strtoupper($sexo);
        $this->idi = $idi;
		$this->idf = $idf;
		$this->dti = $dti;
		$this->dtf = $dtf;
		$this->tpi = $tpi;
		$this->filt = $filt;
		$this->cid2 = $cid2;
		$this->cidadaos = array();

		$where_sexo = "";
		if ($this->sexo != 'T'){
			$where_sexo = "no_sexo = '".$this->sexo."'";
		}

		$where_filt = "";
		if (strlen($this->filt) > 0){
			$pos = strpos($this->filt,':');
			if ($pos === false) {
				// nao encontrado
			} else {
				$ft = explode(':',$this->filt);
				$ft_campo = $ft[0]; // campos da tabela tb_fat_cad_individual (exemplo: st_diabete, st_hipertensao_arterial, st_gestante)
				$ft_tipo = $ft[1]; // T (string), N (mumérico)
				$ft_valor = $ft[2]; // exemplo de $filt = "st_diabete:N:1"
				if ($ft_tipo == 'T'){
					$where_filt = "WHERE ".$ft_campo." = '".$ft_valor."'";
				} else {
					$where_filt = "WHERE ".$ft_campo." = ".$ft_valor;
				}
			}
		}

		$this->ndti = '0000-00-00';
		$this->ndtf = '0000-00-00';
		if ($dti == $dtf){
			if ($dti > 0){
				$this->ndti = $this->ardata($this->nvdata($dti,($idf*$tpi)));
				$this->ndtf = $this->ndti;
			}
		} else {
			if ($dtf > 0){
				if ($dtf > $dti){
					$this->ndti = $this->ardata($this->nvdata($dti,($idf*$tpi)));
					$this->ndtf = $this->ardata($this->nvdata($dtf,($idi*$tpi)));
				}
			} else {
				if ($idi > 0){
					$this->ndti = $this->ardata($this->nvdata($dti,($idf*$tpi)));
					$this->ndtf = $this->ndti;
				}
			}
		}

		$where_idade = "";
		if ($this->ndti != '0000-00-00'){
			if ($idi == $idf){
				if ($idi > 0){
					$where_idade = "(dt_nascimento >= '".$this->ndti."' AND dt_nascimento <= '".$this->ndtf."')";
				}
			} else {
				if ($idf > 0){
					if ($idf > $idi){
						$where_idade = "(dt_nascimento >= '".$this->ndti."' AND dt_nascimento <= '".$this->ndtf."')";
					}
				} else {
					if ($idi > 0){
						$where_idade = "dt_nascimento = '".$this->ndti."'";
					}
				}
			}
		}

		$where = "";
		if (strlen($where_sexo) > 0){
			$where = "WHERE ".$where_sexo;
			if (strlen($where_idade) > 0){
				$where .= " AND ".$where_idade;
			}
		} else {
			if (strlen($where_idade) > 0){
				$where = "WHERE ".$where_idade;
			}
		}
		// ####################################################################################################################################################
		$this->sql1 = "
			SELECT
				*
			FROM
			(
				SELECT DISTINCT ON (no_cidadao, no_mae, dt_nascimento_tb_cidadao)
					t2.*,
					tb_fat_cad_individual.*
				FROM
				(
					SELECT DISTINCT ON (no_cidadao, no_mae, dt_nascimento_tb_cidadao)
						t1.*,
						tb_fat_cidadao_pec.co_seq_fat_cidadao_pec,
						tb_fat_cidadao_pec.co_cidadao
					FROM
					(
						SELECT DISTINCT ON (no_cidadao, no_mae, dt_nascimento_tb_cidadao)
							co_seq_cidadao,
							nu_cpf,
							nu_cns AS nu_cns_tb_cidadao,
							no_cidadao,
							dt_nascimento AS dt_nascimento_tb_cidadao,
							no_mae,
							no_pai,
							dt_obito,
							no_sexo,
							st_unificado,
							TO_CHAR(dt_atualizado, 'YYYYMMDD') as co_dim_tempo_c
						FROM
							tb_cidadao
						".$where."
						ORDER BY no_cidadao, no_mae, dt_nascimento_tb_cidadao, co_seq_cidadao DESC
					) AS t1
					LEFT JOIN
						tb_fat_cidadao_pec
					ON tb_fat_cidadao_pec.co_cidadao = t1.co_seq_cidadao
					ORDER BY no_cidadao, no_mae, dt_nascimento_tb_cidadao, co_seq_fat_cidadao_pec DESC
				) AS t2
				LEFT JOIN
					tb_fat_cad_individual
				ON tb_fat_cad_individual.co_fat_cidadao_pec = t2.co_seq_fat_cidadao_pec
				ORDER BY no_cidadao, no_mae, dt_nascimento_tb_cidadao, co_seq_fat_cad_individual DESC
			) AS tf 
			".$where_filt."
		";
		// ####################################################################################################################################################
		$this->sql2 = "
			SELECT DISTINCT ON (no_cidadao, no_mae, dt_nascimento)
				t1.*,
				tb_fat_cidadao_pec.co_seq_fat_cidadao_pec
			FROM
			(
				SELECT DISTINCT ON (no_cidadao, no_mae, dt_nascimento)
					co_seq_cidadao,
					nu_cns,
					nu_cpf,
					no_cidadao,
					dt_nascimento,
					no_mae,
					no_pai,
					dt_obito,
					no_sexo,
					st_unificado,
					TO_CHAR(dt_atualizado, 'YYYYMMDD') as co_dim_tempo_c
				FROM
					tb_cidadao
				".$where."
				ORDER BY no_cidadao, no_mae, dt_nascimento, co_seq_cidadao DESC
			) AS t1
			LEFT JOIN
				tb_fat_cidadao_pec
			ON tb_fat_cidadao_pec.co_cidadao = t1.co_seq_cidadao
			ORDER BY no_cidadao, no_mae, dt_nascimento, co_seq_fat_cidadao_pec DESC
		";
		// ####################################################################################################################################################
		$this->sql3 = "
			SELECT DISTINCT ON (no_cidadao, no_mae, dt_nascimento)
				*
			FROM
			(
				SELECT
					t1.*,
					tb_sexo.no_identificador AS no_sexo
				FROM
				(
					SELECT
						nu_cns_cidadao AS nu_cns,
						nu_cpf_cidadao AS nu_cpf,
						no_cidadao,
						dt_nascimento,
						no_mae_cidadao AS no_mae,
						no_pai_cidadao AS no_pai,
						dt_obito,
						co_sexo,
						co_seq_cds_cad_individual,
						TO_CHAR(dt_cad_individual, 'YYYYMMDD') as co_dim_tempo_c
					FROM 
						tb_cds_cad_individual 
				) AS t1
				LEFT JOIN
					tb_sexo
				ON t1.co_sexo = tb_sexo.co_sexo
			) AS t2
			".$where."
			ORDER BY no_cidadao, no_mae, dt_nascimento, co_seq_cds_cad_individual DESC
		";
		// ####################################################################################################################################################
		$this->sql4 = "
			SELECT 
				co_seq_fat_cidadao_pec AS co_fat_cidadao_pec_2 
			FROM 
				tb_fat_cidadao_pec
			WHERE
				(nu_cns = ? OR nu_cpf_cidadao = ?) 
				AND co_seq_fat_cidadao_pec <> ?
			ORDER BY co_seq_fat_cidadao_pec DESC LIMIT 1
		";
	}
	private function nvdata($data,$meses=0){  // $data int 20210225 e retorna int Ymd
		$novadata = $data;
		$ano = (int) substr($data,0,4);
		$mes = (int) substr($data,4,2);
		$dia = (int) substr($data,6,2);
		$tmes = "month";
		$novadata = date('Ymd', strtotime('-'.$meses.' '.$tmes, strtotime($dia.'-'.$mes.'-'.$ano)));
		return $novadata;
	}
	
	private function ardata($data){ // 20210320 e transforma em 2021-03-20
		$ndi = substr($data,0,4)."-".substr($data,4,2)."-".substr($data,6,2);
		return $ndi;
	}
	
    public function todos() {
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					//$ctrl_dup = $rows->dt_nascimento.substr($rows->no_cidadao,0,5);
					$ctrl_dup = $rows->dt_nascimento.trim($rows->no_cidadao);
					if (false !== $key = array_search($ctrl_dup, array_column($this->cidadaos, 'ctrl'))) {
						if (strlen($this->cidadaos[$key]['cns']) == 15){
							$this->cidadaos[$key]['cns2'] = $rows->nu_cns;
						} else {
							$this->cidadaos[$key]['cns'] = $rows->nu_cns;
						}
						if (strlen($this->cidadaos[$key]['cpf']) == 11){
							$this->cidadaos[$key]['cpf2'] = $rows->nu_cpf;
						} else {
							$this->cidadaos[$key]['cpf'] = $rows->nu_cpf;
						}
						if (strlen($this->cidadaos[$key]['cidadao']) > 0){
							$this->cidadaos[$key]['cidadao2'] = $rows->co_seq_fat_cidadao_pec;
						} else {
							$this->cidadaos[$key]['cidadao'] = $rows->co_seq_fat_cidadao_pec;
						}
						if (strlen($this->cidadaos[$key]['cidadaoc']) > 0){
							$this->cidadaos[$key]['cidadaoc2'] = $rows->co_seq_cidadao;
						} else {
							$this->cidadaos[$key]['cidadaoc'] = $rows->co_seq_cidadao;
						}
						if ($rows->st_unificado == 1){
							$this->cidadaos[$key]['unificado'] = $rows->st_unificado;
						}
						if (strlen($rows->dt_obito) > 5){
							$this->cidadaos[$key]['dtObito'] = $rows->dt_obito;
						}
						if (strlen($rows->co_dim_tempo_c) > 5){
							$this->cidadaos[$key]['dtAtCad'] = $rows->co_dim_tempo_c;
						}
					} else {
						$this->cidadaos[$conta_array]['ctrl'] = $ctrl_dup;
						$this->cidadaos[$conta_array]['cns'] = $rows->nu_cns;
						$this->cidadaos[$conta_array]['cpf'] = $rows->nu_cpf;
						$this->cidadaos[$conta_array]['cidadao'] = $rows->co_seq_fat_cidadao_pec;
						$this->cidadaos[$conta_array]['cidadaoc'] = $rows->co_seq_cidadao;
						$this->cidadaos[$conta_array]['cns2'] = '';
						$this->cidadaos[$conta_array]['cpf2'] = '';
						$this->cidadaos[$conta_array]['cidadao2'] = '';
						$this->cidadaos[$conta_array]['cidadaoc2'] = '';
						$this->cidadaos[$conta_array]['nome'] = $rows->no_cidadao;
						$this->cidadaos[$conta_array]['dtNascimento'] = $rows->dt_nascimento;
						$this->cidadaos[$conta_array]['mae'] = $rows->no_mae;
						$this->cidadaos[$conta_array]['pai'] = $rows->no_pai;
						$this->cidadaos[$conta_array]['dtObito'] = $rows->dt_obito;
						$this->cidadaos[$conta_array]['dtAtCad'] = $rows->co_dim_tempo_c;
						$this->cidadaos[$conta_array]['unificado'] = $rows->st_unificado;
						$this->cidadaos[$conta_array]['sexo'] = $rows->no_sexo;
						$this->cidadaos[$conta_array]['st_diabete'] = $rows->st_diabete;
						$this->cidadaos[$conta_array]['st_gestante'] = $rows->st_gestante;
						$this->cidadaos[$conta_array]['st_hipertensao_arterial'] = $rows->st_hipertensao_arterial;
						if ($this->cid2){
							$cidadao_pec_2 = $this->con->prepare($this->sql4);
							$cidadao_pec_2->bindParam(1,$rows->nu_cns);
							$cidadao_pec_2->bindParam(2,$rows->nu_cpf);
							$cidadao_pec_2->bindParam(3,$rows->co_fat_cidadao_pec);
							if($cidadao_pec_2->execute()){
								if($cidadao_pec_2->rowCount() > 0){
									while($rows_cidadao_pec_2 = $cidadao_pec_2->fetch(PDO::FETCH_OBJ)){
										$this->cidadaos[$conta_array]['cidadao2'] = $rows_cidadao_pec_2->co_fat_cidadao_pec_2;
									}
								}
							}
						}
						$conta_array++;
					}
				}
			}
		}
    }
    public function total() {
		$rs = $this->con->query($this->sql1);
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
			}
		}
    }
}


?>