<?php
class Consultas {
    public $dti;
	public $dtf;
    public $cpf;
	public $cns;
    public $cpf2;
	public $cns2;
	public $primeiraCons;
	public $totalEncontrado;
	public $consultas = array();
	public $ok;
	public $sql1;
	
	private $con;

    public function __construct($con, $cns, $cpf, $cns2, $cpf2, $dti, $dtf, $ciaps, $cids, $cbos) {
		$this->totalEncontrado = 0;
		$this->ok = false;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->cns = $cns;
		$this->cpf = $cpf;
		$this->cns2 = $cns2;
		$this->cpf2 = $cpf2;
		$this->con = $con;

		$tciaps = "";
		if (count($ciaps) > 0){
			$tciaps = "ds_filtro_ciaps LIKE ANY (array[";
			foreach ($ciaps as $v) {
				$tciaps .= "'%|".$v."|%',";
			}
			$tciaps = substr($tciaps,0,-1);
			$tciaps .= "])";
		}
		$tcids = "";
		if (count($cids) > 0){
			$tcids = "ds_filtro_cids LIKE ANY (array[";
			foreach ($cids as $v) {
				$tcids .= "'%|".$v."|%',";
			}
			$tcids = substr($tcids,0,-1);
			$tcids .= "])";
		}
		$cc = "";
		if (strlen($tciaps) > 0){
			$cc = $tciaps;
			if (strlen($tcids) > 0){
				$cc = "(".$cc." OR ".$tcids.")";
			}
		} else {
			if (strlen($tcids) > 0){
				$cc = $tcids;
			}
		}
		if (strlen($cc) > 0){
			$cc = " AND ".$cc;
		}
		$tcbos = "";
		if (count($cbos) > 0){
			$tcbos = "WHERE nu_cbo LIKE ANY (array[";
			foreach ($cbos as $v) {
				$tcbos .= "'".$v."%',";
			}
			$tcbos = substr($tcbos,0,-1);
			$tcbos .= "])";
		}

		$this->sql1 = "
			SELECT
				*
			FROM
			(
				SELECT
					t5.nu_cns,
					t5.nu_cpf_cidadao,
					t5.co_dim_tempo,
					t5.co_dim_tempo_dum,
					t5.nu_ine,
					t5.no_equipe,
					t5.nu_cnes,
					t5.no_unidade_saude,
					t5.ds_filtro_ciaps,
					t5.ds_filtro_cids,
					t5.nu_idade_gestacional_semanas,
					t5.nu_cbo,
					t5.no_cbo,
					t5.co_fat_cidadao_pec,
					tb_dim_profissional.nu_cns AS cns_prof,
					tb_dim_profissional.no_profissional
				FROM
				(
					SELECT
						t3.*,
						tb_dim_cbo.nu_cbo,
						tb_dim_cbo.no_cbo
					FROM
					(
						SELECT
							t2.*,
							tb_dim_unidade_saude.nu_cnes,
							tb_dim_unidade_saude.no_unidade_saude
						FROM
						(
							SELECT 
								t1.*,
								tb_dim_equipe.nu_ine,
								tb_dim_equipe.no_equipe
							FROM
							(
								SELECT 
									nu_cns,
									nu_cpf_cidadao,
									co_dim_tempo, 
									co_dim_tempo_dum,
									CASE WHEN co_dim_cbo_1 = 1 THEN co_dim_cbo_2
										ELSE co_dim_cbo_1 END
										co_dim_cbo,
									CASE WHEN co_dim_unidade_saude_1 = 1 THEN co_dim_unidade_saude_2
										ELSE co_dim_unidade_saude_1 END
										co_dim_unidade_saude,
									CASE WHEN co_dim_equipe_1 = 1 THEN co_dim_equipe_2
										ELSE co_dim_equipe_1 END
										co_dim_equipe,
									CASE WHEN co_dim_profissional_1 = 1 THEN co_dim_profissional_2
										ELSE co_dim_profissional_1 END
										co_dim_profissional,
									ds_filtro_ciaps,
									ds_filtro_cids,
									nu_idade_gestacional_semanas,
									co_fat_cidadao_pec
								FROM
									tb_fat_atendimento_individual
								WHERE
									(nu_cns = '".$cns."' OR nu_cpf_cidadao = '".$cpf."' OR nu_cns = '".$cns2."' OR nu_cpf_cidadao = '".$cpf2."') AND
									(co_dim_tempo >= ".$dti." AND co_dim_tempo <= ".$dtf.")
									".$cc."
							) AS t1
							LEFT JOIN
								tb_dim_equipe
							ON tb_dim_equipe.co_seq_dim_equipe = t1.co_dim_equipe
						) AS t2
						LEFT JOIN
							tb_dim_unidade_saude
						ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t2.co_dim_unidade_saude
					) AS t3
					LEFT JOIN
						tb_dim_cbo
					ON tb_dim_cbo.co_seq_dim_cbo = t3.co_dim_cbo
				) AS t5
				LEFT JOIN
					tb_dim_profissional
				ON tb_dim_profissional.co_seq_dim_profissional = t5.co_dim_profissional
			) AS t4
			".$tcbos."
			ORDER BY co_dim_tempo
		";
    }
    public function todos() {
		$primeira = true;
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					if ($primeira){
						$this->primeiraCons = $rows->co_dim_tempo;
						$primeira = false;
					}
					$this->consultas[$conta_array]['cns'] = $rows->nu_cns;
					$this->consultas[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->consultas[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
					$this->consultas[$conta_array]['dtDum'] = $rows->co_dim_tempo_dum;
					$this->consultas[$conta_array]['ine'] = $rows->nu_ine;
					$this->consultas[$conta_array]['equipe'] = $rows->no_equipe;
					$this->consultas[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->consultas[$conta_array]['unidade'] = $rows->no_unidade_saude;
					$this->consultas[$conta_array]['idGestacional'] = $rows->nu_idade_gestacional_semanas;
					$this->consultas[$conta_array]['ciaps'] = $rows->ds_filtro_ciaps;
					$this->consultas[$conta_array]['cids'] = $rows->ds_filtro_cids;
					$this->consultas[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->consultas[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->consultas[$conta_array]['cnsProfissional'] = $rows->cns_prof;
					$this->consultas[$conta_array]['nomeProfissional'] = $rows->no_profissional;
					$this->consultas[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$conta_array++;
				}
			}
		}
    }
    public function total() {
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->primeiraCons = $rows->co_dim_tempo;
					break;
				}
			}
		}
    }
}

class ConsultasFAT {
    public $dti;
	public $dtf;
    public $cfat;
	public $primeiraCons;
	public $totalEncontrado;
	public $consultas = array();
	public $ok;
	public $sql1;
	
	private $con;

    public function __construct($con, $cfat, $dti, $dtf, $ciaps, $cids, $cbos) {
		$this->totalEncontrado = 0;
		$this->ok = false;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->cfat = $cfat;
		$this->con = $con;

		$selfat = "";
		$vfats = explode(":",$this->cfat);
		if (count($vfats) > 1){
			foreach ($vfats as $vlf) {
				if (strlen(trim($vlf)) > 0){
					if ($vlf > 0){
						$selfat .= "co_fat_cidadao_pec = ".$vlf." OR ";
					}
				}
			}
			if (strlen($selfat) > 25){
				$selfat = substr($selfat,0,-4);
			}
		} else {
			$selfat = "co_fat_cidadao_pec = ".$vfats[0];
		}


		$tciaps = "";
		if (count($ciaps) > 0){
			$tciaps = "ds_filtro_ciaps LIKE ANY (array[";
			foreach ($ciaps as $v) {
				$tciaps .= "'%|".$v."|%',";
			}
			$tciaps = substr($tciaps,0,-1);
			$tciaps .= "])";
		}
		$tcids = "";
		if (count($cids) > 0){
			$tcids = "ds_filtro_cids LIKE ANY (array[";
			foreach ($cids as $v) {
				$tcids .= "'%|".$v."|%',";
			}
			$tcids = substr($tcids,0,-1);
			$tcids .= "])";
		}
		$cc = "";
		if (strlen($tciaps) > 0){
			$cc = $tciaps;
			if (strlen($tcids) > 0){
				$cc = "(".$cc." OR ".$tcids.")";
			}
		} else {
			if (strlen($tcids) > 0){
				$cc = $tcids;
			}
		}
		if (strlen($cc) > 0){
			$cc = " AND ".$cc;
		}
		$tcbos = "";
		if (count($cbos) > 0){
			$tcbos = "WHERE nu_cbo LIKE ANY (array[";
			foreach ($cbos as $v) {
				$tcbos .= "'".$v."%',";
			}
			$tcbos = substr($tcbos,0,-1);
			$tcbos .= "])";
		}

		$this->sql1 = "
			SELECT
				*
			FROM
			(
				SELECT
					t5.nu_cns,
					t5.nu_cpf_cidadao,
					t5.co_dim_tempo,
					t5.co_dim_tempo_dum,
					t5.nu_ine,
					t5.no_equipe,
					t5.nu_cnes,
					t5.no_unidade_saude,
					t5.ds_filtro_ciaps,
					t5.ds_filtro_cids,
					t5.nu_idade_gestacional_semanas,
					t5.nu_cbo,
					t5.no_cbo,
					t5.co_fat_cidadao_pec,
					tb_dim_profissional.nu_cns AS cns_prof,
					tb_dim_profissional.no_profissional
				FROM
				(
					SELECT
						t3.*,
						tb_dim_cbo.nu_cbo,
						tb_dim_cbo.no_cbo
					FROM
					(
						SELECT
							t2.*,
							tb_dim_unidade_saude.nu_cnes,
							tb_dim_unidade_saude.no_unidade_saude
						FROM
						(
							SELECT 
								t1.*,
								tb_dim_equipe.nu_ine,
								tb_dim_equipe.no_equipe
							FROM
							(
								SELECT 
									nu_cns,
									nu_cpf_cidadao,
									co_dim_tempo, 
									co_dim_tempo_dum,
									CASE WHEN co_dim_cbo_1 = 1 THEN co_dim_cbo_2
										ELSE co_dim_cbo_1 END
										co_dim_cbo,
									CASE WHEN co_dim_unidade_saude_1 = 1 THEN co_dim_unidade_saude_2
										ELSE co_dim_unidade_saude_1 END
										co_dim_unidade_saude,
									CASE WHEN co_dim_equipe_1 = 1 THEN co_dim_equipe_2
										ELSE co_dim_equipe_1 END
										co_dim_equipe,
									CASE WHEN co_dim_profissional_1 = 1 THEN co_dim_profissional_2
										ELSE co_dim_profissional_1 END
										co_dim_profissional,
									ds_filtro_ciaps,
									ds_filtro_cids,
									nu_idade_gestacional_semanas,
									co_fat_cidadao_pec
								FROM
									tb_fat_atendimento_individual
								WHERE
									(".$selfat.") AND
									(co_dim_tempo >= ".$dti." AND co_dim_tempo <= ".$dtf.")
									".$cc."
							) AS t1
							LEFT JOIN
								tb_dim_equipe
							ON tb_dim_equipe.co_seq_dim_equipe = t1.co_dim_equipe
						) AS t2
						LEFT JOIN
							tb_dim_unidade_saude
						ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t2.co_dim_unidade_saude
					) AS t3
					LEFT JOIN
						tb_dim_cbo
					ON tb_dim_cbo.co_seq_dim_cbo = t3.co_dim_cbo
				) AS t5
				LEFT JOIN
					tb_dim_profissional
				ON tb_dim_profissional.co_seq_dim_profissional = t5.co_dim_profissional
			) AS t4
			".$tcbos."
			ORDER BY co_dim_tempo
		";
    }
    public function todos() {
		$primeira = true;
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					if ($primeira){
						$this->primeiraCons = $rows->co_dim_tempo;
						$primeira = false;
					}
					$this->consultas[$conta_array]['cns'] = $rows->nu_cns;
					$this->consultas[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->consultas[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
					$this->consultas[$conta_array]['dtDum'] = $rows->co_dim_tempo_dum;
					$this->consultas[$conta_array]['ine'] = $rows->nu_ine;
					$this->consultas[$conta_array]['equipe'] = $rows->no_equipe;
					$this->consultas[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->consultas[$conta_array]['unidade'] = $rows->no_unidade_saude;
					$this->consultas[$conta_array]['idGestacional'] = $rows->nu_idade_gestacional_semanas;
					$this->consultas[$conta_array]['ciaps'] = $rows->ds_filtro_ciaps;
					$this->consultas[$conta_array]['cids'] = $rows->ds_filtro_cids;
					$this->consultas[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->consultas[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->consultas[$conta_array]['cnsProfissional'] = $rows->cns_prof;
					$this->consultas[$conta_array]['nomeProfissional'] = $rows->no_profissional;
					$this->consultas[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$conta_array++;
				}
			}
		}
    }
    public function total() {
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->primeiraCons = $rows->co_dim_tempo;
					break;
				}
			}
		}
    }
}

class ConsultasCBO {
    public $dti;
	public $dtf;
	public $totalEncontrado;
	public $consultas = array();
	public $equipes = array();
	public $ok;
	public $sql1;
	public $primeiraCons;
	
	private $con;
	private $conta_equipe = 0;

    public function __construct($con, $dti, $dtf, $ciaps, $cids, $cbos, $ines) {
		$this->totalEncontrado = 0;
		$this->ok = false;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->con = $con;

		$tciaps = "";
		if (count($ciaps) > 0){
			$tciaps = "ds_filtro_ciaps LIKE ANY (array[";
			foreach ($ciaps as $v) {
				$tciaps .= "'%|".$v."|%',";
			}
			$tciaps = substr($tciaps,0,-1);
			$tciaps .= "])";
		}
		$tcids = "";
		if (count($cids) > 0){
			$tcids = "ds_filtro_cids LIKE ANY (array[";
			foreach ($cids as $v) {
				$tcids .= "'%|".$v."|%',";
			}
			$tcids = substr($tcids,0,-1);
			$tcids .= "])";
		}
		$cc = "";
		if (strlen($tciaps) > 0){
			$cc = $tciaps;
			if (strlen($tcids) > 0){
				$cc = "(".$cc." OR ".$tcids.")";
			}
		} else {
			if (strlen($tcids) > 0){
				$cc = $tcids;
			}
		}
		if (strlen($cc) > 0){
			$cc = " AND ".$cc;
		}
		$tcbos = "";
		if (count($cbos) > 0){
			$tcbos = "WHERE nu_cbo LIKE ANY (array[";
			foreach ($cbos as $v) {
				$tcbos .= "'".$v."%',";
			}
			$tcbos = substr($tcbos,0,-1);
			$tcbos .= "])";
		}
		/*
		$tines = "";
		if (count($ines) > 0){
			$tines = "WHERE nu_ine IN (";
			if (strlen($tcbos) > 0){
				$tines = "AND nu_ine IN (";
			}
			foreach ($ines as $v) {
				$tines .= "'".$v."',";
			}
			$tines = substr($tines,0,-1);
			$tines .= ")";
		}
		*/
		$tines = "";
		if (count($ines) > 0){
			$tines = "WHERE nu_ine LIKE ANY (array[";
			if (strlen($tcbos) > 0){
				$tines = "AND nu_ine LIKE ANY (array[";
			}
			foreach ($ines as $v) {
				$vn = (int) $v;
				$tines .= "'%".$vn."',";
			}
			$tines = substr($tines,0,-1);
			$tines .= "])";
		}

		$this->sql1 = "
			SELECT
				*
			FROM
			(
				SELECT
					t5.nu_cns,
					t5.nu_cpf_cidadao,
					t5.co_dim_tempo,
					t5.co_dim_tempo_dum,
					t5.nu_ine,
					t5.no_equipe,
					t5.nu_cnes,
					t5.no_unidade_saude,
					t5.ds_filtro_ciaps,
					t5.ds_filtro_cids,
					t5.nu_idade_gestacional_semanas,
					t5.nu_cbo,
					t5.no_cbo,
					t5.co_fat_cidadao_pec,
					tb_dim_profissional.nu_cns AS cns_prof,
					tb_dim_profissional.no_profissional
				FROM
				(
					SELECT
						t3.*,
						tb_dim_cbo.nu_cbo,
						tb_dim_cbo.no_cbo
					FROM
					(
						SELECT
							t2.*,
							tb_dim_unidade_saude.nu_cnes,
							tb_dim_unidade_saude.no_unidade_saude
						FROM
						(
							SELECT 
								t1.*,
								tb_dim_equipe.nu_ine,
								tb_dim_equipe.no_equipe
							FROM
							(
								SELECT 
									nu_cns,
									nu_cpf_cidadao,
									co_dim_tempo, 
									co_dim_tempo_dum,
									CASE WHEN co_dim_cbo_1 = 1 THEN co_dim_cbo_2
										ELSE co_dim_cbo_1 END
										co_dim_cbo,
									CASE WHEN co_dim_unidade_saude_1 = 1 THEN co_dim_unidade_saude_2
										ELSE co_dim_unidade_saude_1 END
										co_dim_unidade_saude,
									CASE WHEN co_dim_equipe_1 = 1 THEN co_dim_equipe_2
										ELSE co_dim_equipe_1 END
										co_dim_equipe,
									CASE WHEN co_dim_profissional_1 = 1 THEN co_dim_profissional_2
										ELSE co_dim_profissional_1 END
										co_dim_profissional,
									ds_filtro_ciaps,
									ds_filtro_cids,
									nu_idade_gestacional_semanas,
									co_fat_cidadao_pec
								FROM
									tb_fat_atendimento_individual
								WHERE
									(co_dim_tempo >= ".$dti." AND co_dim_tempo <= ".$dtf.")
									".$cc."
							) AS t1
							LEFT JOIN
								tb_dim_equipe
							ON tb_dim_equipe.co_seq_dim_equipe = t1.co_dim_equipe
						) AS t2
						LEFT JOIN
							tb_dim_unidade_saude
						ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t2.co_dim_unidade_saude
					) AS t3
					LEFT JOIN
						tb_dim_cbo
					ON tb_dim_cbo.co_seq_dim_cbo = t3.co_dim_cbo
				) AS t5
				LEFT JOIN
					tb_dim_profissional
				ON tb_dim_profissional.co_seq_dim_profissional = t5.co_dim_profissional
			) AS t4
			".$tcbos." ".$tines."
			ORDER BY co_dim_tempo
		";
    }
    public function todos() {
		$primeira = true;
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					if ($primeira){
						$this->primeiraCons = $rows->co_dim_tempo;
						$primeira = false;
					}
					$this->consultas[$conta_array]['cns'] = $rows->nu_cns;
					$this->consultas[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->consultas[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
					$this->consultas[$conta_array]['dtDum'] = $rows->co_dim_tempo_dum;
					$this->consultas[$conta_array]['ine'] = $rows->nu_ine;
					$this->consultas[$conta_array]['equipe'] = $rows->no_equipe;
					$this->consultas[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->consultas[$conta_array]['unidade'] = $rows->no_unidade_saude;
					$this->consultas[$conta_array]['idGestacional'] = $rows->nu_idade_gestacional_semanas;
					$this->consultas[$conta_array]['ciaps'] = $rows->ds_filtro_ciaps;
					$this->consultas[$conta_array]['cids'] = $rows->ds_filtro_cids;
					$this->consultas[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->consultas[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->consultas[$conta_array]['cnsProfissional'] = $rows->cns_prof;
					$this->consultas[$conta_array]['nomeProfissional'] = $rows->no_profissional;
					$this->consultas[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$conta_array++;
					if (false !== $key = array_search($rows->nu_ine, array_column($this->equipes, 'ine'))) {
						$this->equipes[$key]['total'] = $this->equipes[$key]['total'] + 1;
					} else {
						$this->equipes[$this->conta_equipe]['ine'] = $rows->nu_ine;
						$this->equipes[$this->conta_equipe]['nome'] = $rows->no_equipe;
						$this->equipes[$this->conta_equipe]['total'] = 0;
						$this->equipes[$this->conta_equipe]['dti'] = $this->dti;
						$this->equipes[$this->conta_equipe]['dtf'] = $this->dtf;
						$this->conta_equipe++;
					}
				}
			}
		}
    }
    public function total() {
		$rs = $this->con->query($this->sql1);
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->primeiraCons = $rows->co_dim_tempo;
					break;
				}
			}
		}
    }
}


?>



