<?php
require_once('core/sec.php');

$smtp_email = '';
$smtp_usuario = '';
$smtp_senha = '';
$smtp_servidor = '';
$smtp_porta = '587';
$smtp_cript = 'tls';
$smtp_html = 'true';
$smtp_aut = 'true';
$smtp_tsen = 'false';

$rs = $con->prepare("SELECT * FROM sc_tb_cf_geral WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
      $smtp_email = $row->smtp_email;
      $smtp_usuario = $row->smtp_usuario;
      $smtp_senha = $row->smtp_senha;
      $smtp_servidor = $row->smtp_servidor;
      $smtp_porta = $row->smtp_porta;
      $smtp_cript = $row->smtp_cript;
      $smtp_html = $row->smtp_html;
      $smtp_aut = $row->smtp_aut;
      $smtp_tsen = $row->smtp_tsen;
		}
	}
}

?>
<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Configuração do e-mail</h4>
                </div>
                <div class="card-body mt-2">
                  <p class="card-text">Dados para o envio de mensagens</p>
                  <form class="dt_adv_search" name="frm" id="frm" method="POST">
                    <div class="row g-1 mb-md-1">

                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="smtpemail">Email</label>
				                    <input type="text" class="form-control" name="smtpemail" id="smtpemail" value="<?php echo $smtp_email;?>">
                        </div>
                        <div class="col-xl-2 col-md-6 col-12 mb-1 mb-md-0">
                            <label class="form-label" for="smtpusuario">Usuário</label>
                            <input type="text" class="form-control" name="smtpusuario" id="smtpusuario" value="<?php echo $smtp_usuario;?>" />
                        </div>
                        <div class="col-xl-2 col-md-6 col-12 mb-1 mb-md-0">
                            <label class="form-label" for="smtpsenha">Senha</label>
                            <input type="password" class="form-control" name="smtpsenha" id="smtpsenha" value="<?php echo $smtp_senha;?>" />
                        </div>
                        <div class="col-xl-6 col-md-6 col-12">
                            <label class="form-label" for="smtpservidor">Servidor</label>
                            <input type="text" class="form-control" name="smtpservidor" id="smtpservidor" value="<?php echo $smtp_servidor;?>" /><br>
                        </div>
                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="smtpporta">Porta</label>
				                    <input type="text" class="form-control" name="smtpporta" id="smtpporta" value="<?php echo $smtp_porta;?>">
                        </div>



                        <div class="col-xl-2 col-md-6 col-12">
                            <div class="mb-1">
                                <label class="form-label">Criptografia</label>
                                <select class="form-select" aria-label="Default select example" name="smtpcript" id="smtpcript">
                                <?php
                                    if ($smtp_cript == '1'){
                                        echo "
                                        <option value=\"tls\" selected>TLS (587)</option>
                                        <option value=\"ssl\">SSL (465)</option>
                                        ";
                                    } else {
                                        echo "
                                        <option value=\"tls\">TLS (587)</option>
                                        <option value=\"ssl\" selected>SSL (465)</option>
                                        ";
                                    }
                                ?>
				                        </select>
                            </div>
                        </div>

                        <div class="col-xl-2 col-md-6 col-12">
                            <div class="mb-1">
                                <label class="form-label">HTML</label>
                                <select class="form-select" aria-label="Default select example" name="smtphtml" id="smtphtml">
                                <?php
                                    if ($smtp_html == 'true'){
                                        echo "
                                        <option value=\"true\" selected>Sim</option>
                                        <option value=\"false\">Não</option>
                                        ";
                                    } else {
                                        echo "
                                        <option value=\"true\">Sim</option>
                                        <option value=\"false\" selected>Não</option>
                                        ";
                                    }
                                ?>
				                        </select>
                            </div>
                        </div>

                        <div class="col-xl-2 col-md-6 col-12">
                            <div class="mb-1">
                                <label class="form-label">Autenticação</label>
                                <select class="form-select" aria-label="Default select example" name="smtpaut" id="smtpaut">
                                <?php
                                    if ($smtp_aut == 'true'){
                                        echo "
                                        <option value=\"true\" selected>Sim</option>
                                        <option value=\"false\">Não</option>
                                        ";
                                    } else {
                                        echo "
                                        <option value=\"true\">Sim</option>
                                        <option value=\"false\" selected>Não</option>
                                        ";
                                    }
                                ?>
				                        </select>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary" id="button-addon2">Gravar</button>
                    </div>

                  </form>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
$(function () {
  $('#frm').validate({
    submitHandler: function (form) {

        $.post('gv_email.php', $('#frm').serialize(), function (data, textStatus) {
          if (data == 'Ok'){ 
            swal.fire('Ok!','Gravado com sucesso!','success');
            $('.content-body').load('frm_email.php');
          } else {
            swal.fire('erro!',data,'error');
          }
        });

    },
    rules: {
      smtpemail: {
          required: true,
          email: true
        },
        smtpusuario: {
          required: true
        },
        smtpsenha: {
          required: true
        },
        smtpservidor: {
          required: true
        },
        smtpporta: {
          required: true,
          number: true
        }
    },
    messages: {
      smtpemail: {
          required: "Este campo é necessário",
          email: "Tem que ser um e-mail válido"
        },
        smtpusuario: {
          required: "Este campo é necessário"
        },
        smtpsenha: {
          required: "Este campo é necessário"
        },
        smtpservidor: {
          required: "Este campo é necessário"
        },
        smtpporta: {
          required: "Este campo é necessário",
          number: "Precisa ser número"
        }
    }
  });
})
</script>